/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;

public class KeepAliveMessage
extends UDPConnectionMessage {
    private long _windowStart;
    private int _windowSpace;

    public KeepAliveMessage(byte by, long l, int n) {
        super(by, (byte)2, 0L, KeepAliveMessage.buildByteArray((int)l & 0xFFFF, n < 0 ? 0 : n), 4);
        this._windowStart = l;
        this._windowSpace = n;
    }

    public KeepAliveMessage(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, byArray2);
        this._windowStart = KeepAliveMessage.getShortInt(byArray[4], byArray[5]);
        this._windowSpace = KeepAliveMessage.getShortInt(byArray[6], byArray[7]);
    }

    public long getWindowStart() {
        return this._windowStart;
    }

    public void extendWindowStart(long l) {
        this._windowStart = l;
    }

    public int getWindowSpace() {
        return this._windowSpace;
    }

    public String toString() {
        return "KeepAliveMessage DestID:" + this.getConnectionID() + " start:" + this._windowStart + " space:" + this._windowSpace;
    }
}

