/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.udpconnect.AckMessage;
import com.limegroup.gnutella.udpconnect.DataMessage;
import com.limegroup.gnutella.udpconnect.FinMessage;
import com.limegroup.gnutella.udpconnect.KeepAliveMessage;
import com.limegroup.gnutella.udpconnect.SynMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class UDPConnectionMessage
extends Message {
    public static final int PROTOCOL_VERSION_NUMBER = 0;
    protected static final byte OP_SYN = 0;
    protected static final byte OP_ACK = 1;
    protected static final byte OP_KEEPALIVE = 2;
    protected static final byte OP_DATA = 3;
    protected static final byte OP_FIN = 4;
    protected static final int GUID_SIZE = 16;
    protected static final int MAX_GUID_DATA = 12;
    protected static final int GUID_DATA_START = 4;
    protected static byte[] emptyByteArray = new byte[0];
    protected byte _connectionID;
    protected byte _opcode;
    protected long _sequenceNumber;
    protected ByteBuffer _data1;
    protected ByteBuffer _data2;
    private static final BadPacketException NO_MATCH = new BadPacketException("No matching UDPConnectionMessage");

    public static UDPConnectionMessage createMessage(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        byte by3 = (byte)((byArray[1] & 0xF0) >> 4);
        switch (by3) {
            case 0: {
                return new SynMessage(byArray, by, by2, byArray2);
            }
            case 1: {
                return new AckMessage(byArray, by, by2, byArray2);
            }
            case 2: {
                return new KeepAliveMessage(byArray, by, by2, byArray2);
            }
            case 3: {
                return new DataMessage(byArray, by, by2, byArray2);
            }
            case 4: {
                return new FinMessage(byArray, by, by2, byArray2);
            }
        }
        throw NO_MATCH;
    }

    protected UDPConnectionMessage(byte by, byte by2, long l, byte[] byArray, int n) {
        super(UDPConnectionMessage.buildGUID(by, by2, l, byArray, n), (byte)65, (byte)1, (byte)0, UDPConnectionMessage.calcPayloadLength(n));
        this._connectionID = by;
        this._opcode = by2;
        this._sequenceNumber = l;
        this._data1 = n > 0 ? ByteBuffer.wrap(byArray, 0, n >= 12 ? 12 : n) : BufferUtils.getEmptyBuffer();
        this._data2 = n > 12 ? ByteBuffer.wrap(byArray, 12, this.getLength()) : BufferUtils.getEmptyBuffer();
    }

    protected UDPConnectionMessage(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        super(byArray, (byte)65, by, by2, byArray2.length);
        this.unpackFromWire(byArray, byArray2);
    }

    public byte getConnectionID() {
        return this._connectionID;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void extendSequenceNumber(long l) {
        this._sequenceNumber = l;
    }

    private static byte[] buildGUID(byte by, byte by2, long l, byte[] byArray, int n) {
        int n2 = n >= 12 ? 12 : n;
        byte[] byArray2 = new byte[16];
        byArray2[0] = by;
        byArray2[1] = (byte)((by2 & 0xF) << 4 | (byte)n2 & 0xF);
        byArray2[2] = (byte)((l & 0xFF00L) >> 8);
        byArray2[3] = (byte)(l & 0xFFL);
        int n3 = 4 + n2;
        int n4 = 4;
        while (n4 < n3) {
            byArray2[n4] = byArray[n4 - 4];
            ++n4;
        }
        return byArray2;
    }

    private static int calcPayloadLength(int n) {
        return n <= 12 ? 0 : n - 12;
    }

    private void unpackFromWire(byte[] byArray, byte[] byArray2) throws BadPacketException {
        this._connectionID = byArray[0];
        this._opcode = (byte)((byArray[1] & 0xF0) >> 4);
        this._sequenceNumber = ((long)byArray[2] & 0xFFL) << 8 | (long)byArray[3] & 0xFFL;
        this._data1 = ByteBuffer.wrap(byArray, 4, byArray[1] & 0xF);
        this._data2 = ByteBuffer.wrap(byArray2);
        if (this._data1.remaining() > 12) {
            throw new BadPacketException("GUID data too big");
        }
    }

    public static byte[] buildByteArray(byte by) {
        byte[] byArray = new byte[]{by};
        return byArray;
    }

    public static byte[] buildByteArray(byte by, int n) {
        byte[] byArray = new byte[]{by, (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        return byArray;
    }

    public static byte[] buildByteArray(int n, int n2) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF), (byte)((n2 & 0xFF00) >> 8), (byte)(n2 & 0xFF)};
        return byArray;
    }

    public static int getShortInt(byte by, byte by2) {
        return (by & 0xFF) << 8 | by2 & 0xFF;
    }

    public int getDataLength() {
        return this._data1.remaining() + this.getLength();
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        if (this._data2.remaining() > 0) {
            outputStream.write(this._data2.array(), this._data2.position(), this._data2.remaining());
        }
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public void recordDrop() {
    }
}

