/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.InterestReadChannel;
import com.limegroup.gnutella.io.InterestWriteChannel;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.io.WriteObserver;
import com.limegroup.gnutella.udpconnect.ChunkReleaser;
import com.limegroup.gnutella.udpconnect.DataMessage;
import com.limegroup.gnutella.udpconnect.DataRecord;
import com.limegroup.gnutella.udpconnect.DataWindow;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;

class UDPSocketChannel
extends SocketChannel
implements InterestReadChannel,
InterestWriteChannel,
ChunkReleaser {
    private final UDPConnectionProcessor processor;
    private Socket socket;
    private final DataWindow readData;
    private volatile WriteObserver writer;
    private ArrayList chunks;
    private ByteBuffer activeChunk;
    private boolean writeHandled = false;
    private final Object writeLock = new Object();
    private boolean shutdown = false;

    UDPSocketChannel(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this.processor = new UDPConnectionProcessor(this);
        this.readData = this.processor.getReadWindow();
        this.chunks = new ArrayList(5);
        this.allocateNewChunk();
        try {
            this.configureBlocking(false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    UDPSocketChannel(UDPConnectionProcessor uDPConnectionProcessor) {
        super(null);
        this.processor = uDPConnectionProcessor;
        this.readData = uDPConnectionProcessor.getReadWindow();
        this.chunks = new ArrayList(5);
        this.allocateNewChunk();
        try {
            this.configureBlocking(false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    UDPConnectionProcessor getProcessor() {
        return this.processor;
    }

    public void interest(boolean bl) {
        NIODispatcher.instance().interestRead(this, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        UDPConnectionProcessor uDPConnectionProcessor = this.processor;
        synchronized (uDPConnectionProcessor) {
            int n;
            block7: {
                n = 0;
                DataRecord dataRecord = this.readData.getReadableBlock();
                while (dataRecord != null) {
                    n += this.transfer(dataRecord, byteBuffer);
                    if (!byteBuffer.hasRemaining()) break;
                    dataRecord = this.readData.getReadableBlock();
                }
                int n2 = this.readData.getWindowSpace();
                this.readData.clearEarlyReadBlocks();
                if (n2 == 0 && n > 0 || (long)n2 <= 2L && (long)this.readData.getWindowSpace() > 2L) {
                    this.processor.sendKeepAlive();
                }
                if (n != 0 || !this.processor.isClosed()) break block7;
                return -1;
            }
            return n;
        }
    }

    private int transfer(DataRecord dataRecord, ByteBuffer byteBuffer) {
        DataMessage dataMessage = dataRecord.msg;
        int n = 0;
        ByteBuffer byteBuffer2 = dataMessage.getData1Chunk();
        if (byteBuffer2.hasRemaining()) {
            n += BufferUtils.transfer(byteBuffer2, byteBuffer, false);
        }
        if (byteBuffer2.hasRemaining()) {
            return n;
        }
        byteBuffer2 = dataMessage.getData2Chunk();
        n += BufferUtils.transfer(byteBuffer2, byteBuffer, false);
        if (!byteBuffer2.hasRemaining()) {
            dataRecord.read = true;
        }
        return n;
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!this.isOpen() || this.processor.isClosed()) {
            throw new ClosedChannelException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            if (this.getNumberOfPendingChunks() == 0) {
                this.processor.wakeupWriteEvent(!this.writeHandled);
            }
            this.writeHandled = true;
            int n = 0;
            while (byteBuffer.hasRemaining()) {
                if (this.activeChunk.hasRemaining()) {
                    n += BufferUtils.transfer(byteBuffer, this.activeChunk, false);
                    continue;
                }
                if (this.chunks.size() < this.processor.getChunkLimit()) {
                    this.chunks.add(this.activeChunk);
                    this.allocateNewChunk();
                    continue;
                }
                return n;
            }
            return n;
        }
    }

    private void allocateNewChunk() {
        this.activeChunk = NIODispatcher.instance().getBufferCache().getHeap(512);
    }

    public void releaseChunk(ByteBuffer byteBuffer) {
        NIODispatcher.instance().getBufferCache().release(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getNextChunk() {
        Object object = this.writeLock;
        synchronized (object) {
            ByteBuffer byteBuffer;
            if (this.chunks.size() > 0) {
                byteBuffer = (ByteBuffer)this.chunks.remove(0);
                byteBuffer.flip();
            } else if (this.activeChunk.position() > 0) {
                byteBuffer = this.activeChunk;
                byteBuffer.flip();
                this.allocateNewChunk();
            } else {
                byteBuffer = null;
            }
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfPendingChunks() {
        Object object = this.writeLock;
        synchronized (object) {
            int n = this.chunks.size();
            if (this.activeChunk.position() > 0) {
                ++n;
            }
            return n;
        }
    }

    Object writeLock() {
        return this.writeLock;
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.processor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        WriteObserver writeObserver = this;
        synchronized (writeObserver) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {}
        writeObserver = this.writer;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
        this.writer = null;
    }

    public void interest(WriteObserver writeObserver, boolean bl) {
        if (this.isOpen()) {
            this.writer = writeObserver;
            NIODispatcher.instance().interestWrite(this, bl);
        }
    }

    public boolean handleWrite() throws IOException {
        WriteObserver writeObserver = this.writer;
        if (writeObserver != null) {
            return writeObserver.handleWrite();
        }
        return false;
    }

    public void handleIOException(IOException iOException) {
        throw new UnsupportedOperationException();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.processor.getSocketAddress();
    }

    public boolean connect(SocketAddress socketAddress) throws IOException {
        this.processor.connect((InetSocketAddress)socketAddress);
        return false;
    }

    public boolean finishConnect() throws IOException {
        return this.processor.prepareOpenConnection();
    }

    public boolean isConnected() {
        return this.processor.isConnected();
    }

    public boolean isConnectionPending() {
        return this.processor.isConnecting();
    }

    public Socket socket() {
        return this.socket;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        throw new IOException("unsupported");
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        throw new IOException("unsupported");
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
    }
}

