/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.BandwidthThrottle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NormalUploadState
extends UploadState {
    private static final Log LOG;
    private static final int BLOCK_SIZE = 1024;
    private final int _index;
    private final String _fileName;
    private final int _fileSize;
    private InputStream _fis;
    private int _amountWritten;
    private int _uploadBegin;
    private int _uploadEnd;
    private int _amountRequested;
    private StalledUploadWatchdog _stalledChecker;
    private static final BandwidthThrottle THROTTLE;
    private static final BandwidthThrottle UDP_THROTTLE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.uploader.NormalUploadState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        THROTTLE = new BandwidthThrottle(NormalUploadState.getUploadSpeed(), false);
        UDP_THROTTLE = new BandwidthThrottle(NormalUploadState.getUploadSpeed(), false);
    }

    public NormalUploadState(HTTPUploader hTTPUploader, StalledUploadWatchdog stalledUploadWatchdog) {
        super(hTTPUploader);
        LOG.debug((Object)"creating a normal upload state");
        this._index = this.UPLOADER.getIndex();
        this._fileName = this.UPLOADER.getFileName();
        this._fileSize = this.UPLOADER.getFileSize();
        this._amountWritten = 0;
        this._stalledChecker = stalledUploadWatchdog;
    }

    public static void setThrottleSwitching(boolean bl) {
        THROTTLE.setSwitching(bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing message headers");
        try {
            StringWriter stringWriter = new StringWriter();
            this._fis = this.UPLOADER.getInputStream();
            this._uploadBegin = this.UPLOADER.getUploadBegin();
            this._uploadEnd = this.UPLOADER.getUploadEnd();
            this._amountRequested = this.UPLOADER.getAmountRequested();
            if (this._fileSize < this._uploadBegin) {
                throw new IOException("Invalid Range");
            }
            if (this._uploadBegin == 0 && this._amountRequested == this._fileSize) {
                ((Writer)stringWriter).write("HTTP/1.1 200 OK\r\n");
            } else {
                ((Writer)stringWriter).write("HTTP/1.1 206 Partial Content\r\n");
            }
            HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, (Writer)stringWriter);
            HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_TYPE, this.getMimeType(), (Writer)stringWriter);
            HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_LENGTH, this._amountRequested, (Writer)stringWriter);
            HTTPUtils.writeDate(stringWriter);
            HTTPUtils.writeContentDisposition(this._fileName, stringWriter);
            if (this._uploadBegin != 0 || this._amountRequested != this._fileSize) {
                ((Writer)stringWriter).write("Content-Range: bytes " + this._uploadBegin + "-" + (this._uploadEnd - 1) + "/" + this._fileSize + "\r\n");
            }
            this.writeAlts(stringWriter);
            this.writeRanges(stringWriter);
            this.writeProxies(stringWriter);
            if (this.FILE_DESC != null) {
                CreationTimeCache creationTimeCache;
                URN uRN = this.FILE_DESC.getSHA1Urn();
                if (this.UPLOADER.isFirstReply() && (creationTimeCache = CreationTimeCache.instance()).getCreationTime(uRN) != null) {
                    HTTPUtils.writeHeader(HTTPHeaderName.CREATION_TIME, creationTimeCache.getCreationTime(uRN).toString(), (Writer)stringWriter);
                }
            }
            if (this.UPLOADER.isFirstReply()) {
                HTTPUtils.writeFeatures(stringWriter);
            }
            if (this.FILE_DESC.getHashTree() != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.THEX_URI, (HTTPHeaderValue)this.FILE_DESC.getHashTree(), (Writer)stringWriter);
            }
            ((Writer)stringWriter).write("\r\n");
            this._stalledChecker.activate(outputStream);
            outputStream.write(((Object)stringWriter).toString().getBytes());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._stalledChecker.deactivate();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this._stalledChecker.deactivate();
        }
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        LOG.debug((Object)"writing message body");
        try {
            this._fis.skip(this._uploadBegin);
            this.upload(outputStream);
        }
        catch (IOException iOException) {
            this._stalledChecker.deactivate();
            throw iOException;
        }
    }

    private void upload(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        do {
            BandwidthThrottle bandwidthThrottle = this.UPLOADER.isUDPTransfer() ? UDP_THROTTLE : THROTTLE;
            bandwidthThrottle.setRate(NormalUploadState.getUploadSpeed());
            int n = -1;
            int n2 = 1024;
            if (!this.UPLOADER.isForcedShare()) {
                n2 = bandwidthThrottle.request(1024);
            }
            int n3 = 0;
            try {
                n = this._fis.read(byArray, 0, n2);
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException(nullPointerException.getMessage());
            }
            if (n == -1) {
                return;
            }
            if (n > this._amountRequested - this._amountWritten) {
                n = this._amountRequested - this._amountWritten;
            }
            this._stalledChecker.activate(outputStream);
            outputStream.write(byArray, 0, n);
            this._stalledChecker.deactivate();
            this._amountWritten += n;
            this.UPLOADER.setAmountUploaded(this._amountWritten);
            n3 += n;
        } while (this._amountWritten < this._amountRequested);
    }

    private String getMimeType() {
        return "application/binary";
    }

    private static float getUploadSpeed() {
        int n = UploadSettings.UPLOAD_SPEED.getValue();
        float f = n == 100 ? Float.MAX_VALUE : Math.max((float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f * (float)n / 100.0f - RouterService.getConnectionManager().getMeasuredUpstreamBandwidth() * 1.0f, 1.0f) * 1024.0f;
        return f;
    }

    public boolean getCloseConnection() {
        return false;
    }

    public String toString() {
        return "NormalUploadState:\r\nFile Name:  " + this._fileName + "\r\n" + "File Size:  " + this._fileSize + "\r\n" + "File Index: " + this._index + "\r\n" + "File Desc:  " + this.FILE_DESC;
    }
}

