/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private long[] bits;
    private transient int unitsInUse = 0;
    private static final long serialVersionUID = 7997698588986878753L;
    private static final byte[] trailingZeroTable;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -25;
        byArray[2] = 1;
        byArray[4] = 2;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[10] = 1;
        byArray[12] = 2;
        byArray[14] = 1;
        byArray[16] = 4;
        byArray[18] = 1;
        byArray[20] = 2;
        byArray[22] = 1;
        byArray[24] = 3;
        byArray[26] = 1;
        byArray[28] = 2;
        byArray[30] = 1;
        byArray[32] = 5;
        byArray[34] = 1;
        byArray[36] = 2;
        byArray[38] = 1;
        byArray[40] = 3;
        byArray[42] = 1;
        byArray[44] = 2;
        byArray[46] = 1;
        byArray[48] = 4;
        byArray[50] = 1;
        byArray[52] = 2;
        byArray[54] = 1;
        byArray[56] = 3;
        byArray[58] = 1;
        byArray[60] = 2;
        byArray[62] = 1;
        byArray[64] = 6;
        byArray[66] = 1;
        byArray[68] = 2;
        byArray[70] = 1;
        byArray[72] = 3;
        byArray[74] = 1;
        byArray[76] = 2;
        byArray[78] = 1;
        byArray[80] = 4;
        byArray[82] = 1;
        byArray[84] = 2;
        byArray[86] = 1;
        byArray[88] = 3;
        byArray[90] = 1;
        byArray[92] = 2;
        byArray[94] = 1;
        byArray[96] = 5;
        byArray[98] = 1;
        byArray[100] = 2;
        byArray[102] = 1;
        byArray[104] = 3;
        byArray[106] = 1;
        byArray[108] = 2;
        byArray[110] = 1;
        byArray[112] = 4;
        byArray[114] = 1;
        byArray[116] = 2;
        byArray[118] = 1;
        byArray[120] = 3;
        byArray[122] = 1;
        byArray[124] = 2;
        byArray[126] = 1;
        byArray[128] = 7;
        byArray[130] = 1;
        byArray[132] = 2;
        byArray[134] = 1;
        byArray[136] = 3;
        byArray[138] = 1;
        byArray[140] = 2;
        byArray[142] = 1;
        byArray[144] = 4;
        byArray[146] = 1;
        byArray[148] = 2;
        byArray[150] = 1;
        byArray[152] = 3;
        byArray[154] = 1;
        byArray[156] = 2;
        byArray[158] = 1;
        byArray[160] = 5;
        byArray[162] = 1;
        byArray[164] = 2;
        byArray[166] = 1;
        byArray[168] = 3;
        byArray[170] = 1;
        byArray[172] = 2;
        byArray[174] = 1;
        byArray[176] = 4;
        byArray[178] = 1;
        byArray[180] = 2;
        byArray[182] = 1;
        byArray[184] = 3;
        byArray[186] = 1;
        byArray[188] = 2;
        byArray[190] = 1;
        byArray[192] = 6;
        byArray[194] = 1;
        byArray[196] = 2;
        byArray[198] = 1;
        byArray[200] = 3;
        byArray[202] = 1;
        byArray[204] = 2;
        byArray[206] = 1;
        byArray[208] = 4;
        byArray[210] = 1;
        byArray[212] = 2;
        byArray[214] = 1;
        byArray[216] = 3;
        byArray[218] = 1;
        byArray[220] = 2;
        byArray[222] = 1;
        byArray[224] = 5;
        byArray[226] = 1;
        byArray[228] = 2;
        byArray[230] = 1;
        byArray[232] = 3;
        byArray[234] = 1;
        byArray[236] = 2;
        byArray[238] = 1;
        byArray[240] = 4;
        byArray[242] = 1;
        byArray[244] = 2;
        byArray[246] = 1;
        byArray[248] = 3;
        byArray[250] = 1;
        byArray[252] = 2;
        byArray[254] = 1;
        trailingZeroTable = byArray;
    }

    private static int unitIndex(int n) {
        return n >> 6;
    }

    private static long bit(int n) {
        return 1L << (n & 0x3F);
    }

    private void recalculateUnitsInUse() {
        int n = this.unitsInUse - 1;
        while (n >= 0) {
            if (this.bits[n] != 0L) break;
            --n;
        }
        this.unitsInUse = n + 1;
    }

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + n);
        }
        this.bits = new long[BitSet.unitIndex(n - 1) + 1];
    }

    private void ensureCapacity(int n) {
        if (this.bits.length < n) {
            int n2 = Math.max(2 * this.bits.length, n);
            long[] lArray = new long[n2];
            System.arraycopy(this.bits, 0, lArray, 0, this.unitsInUse);
            this.bits = lArray;
        }
    }

    public void compact() {
        if (this.bits.length > this.unitsInUse) {
            long[] lArray = new long[this.unitsInUse];
            System.arraycopy(this.bits, 0, lArray, 0, this.unitsInUse);
            this.bits = lArray;
        }
    }

    public void flip(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        int n3 = n2 + 1;
        if (this.unitsInUse < n3) {
            this.ensureCapacity(n3);
            int n4 = n2;
            this.bits[n4] = this.bits[n4] ^ BitSet.bit(n);
            this.unitsInUse = n3;
        } else {
            int n5 = n2;
            this.bits[n5] = this.bits[n5] ^ BitSet.bit(n);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
        }
    }

    public void flip(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
        int n3 = BitSet.unitIndex(n2);
        int n4 = n3 + 1;
        if (this.unitsInUse < n4) {
            this.ensureCapacity(n4);
            this.unitsInUse = n4;
        }
        int n5 = BitSet.unitIndex(n);
        long l = 0L;
        if (n5 == n3) {
            l = (1L << (n2 & 0x3F)) - (1L << (n & 0x3F));
            int n6 = n5;
            this.bits[n6] = this.bits[n6] ^ l;
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        l = BitSet.bitsLeftOf(n & 0x3F);
        int n7 = n5;
        this.bits[n7] = this.bits[n7] ^ l;
        if (n3 - n5 > 1) {
            int n8 = n5 + 1;
            while (n8 < n3) {
                int n9 = n8++;
                this.bits[n9] = this.bits[n9] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l = BitSet.bitsRightOf(n2 & 0x3F);
        int n10 = n3;
        this.bits[n10] = this.bits[n10] ^ l;
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    private static long bitsRightOf(int n) {
        return n == 0 ? 0L : -1L >>> 64 - n;
    }

    private static long bitsLeftOf(int n) {
        return -1L << n;
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        int n3 = n2 + 1;
        if (this.unitsInUse < n3) {
            this.ensureCapacity(n3);
            int n4 = n2;
            this.bits[n4] = this.bits[n4] | BitSet.bit(n);
            this.unitsInUse = n3;
        } else {
            int n5 = n2;
            this.bits[n5] = this.bits[n5] | BitSet.bit(n);
        }
    }

    public void set(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void set(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
        int n3 = BitSet.unitIndex(n2);
        int n4 = n3 + 1;
        if (this.unitsInUse < n4) {
            this.ensureCapacity(n4);
            this.unitsInUse = n4;
        }
        int n5 = BitSet.unitIndex(n);
        long l = 0L;
        if (n5 == n3) {
            l = (1L << (n2 & 0x3F)) - (1L << (n & 0x3F));
            int n6 = n5;
            this.bits[n6] = this.bits[n6] | l;
            return;
        }
        l = BitSet.bitsLeftOf(n & 0x3F);
        int n7 = n5;
        this.bits[n7] = this.bits[n7] | l;
        if (n3 - n5 > 1) {
            int n8 = n5 + 1;
            while (n8 < n3) {
                int n9 = n8++;
                this.bits[n9] = this.bits[n9] | 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l = BitSet.bitsRightOf(n2 & 0x3F);
        int n10 = n3;
        this.bits[n10] = this.bits[n10] | l;
    }

    public void set(int n, int n2, boolean bl) {
        if (bl) {
            this.set(n, n2);
        } else {
            this.clear(n, n2);
        }
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        if (n2 >= this.unitsInUse) {
            return;
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (BitSet.bit(n) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
        int n3 = BitSet.unitIndex(n);
        if (n3 >= this.unitsInUse) {
            return;
        }
        int n4 = BitSet.unitIndex(n2);
        long l = 0L;
        if (n3 == n4) {
            l = (1L << (n2 & 0x3F)) - (1L << (n & 0x3F));
            int n5 = n3;
            this.bits[n5] = this.bits[n5] & (l ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        l = BitSet.bitsLeftOf(n & 0x3F);
        int n6 = n3;
        this.bits[n6] = this.bits[n6] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        if (n4 - n3 > 1) {
            int n7 = n3 + 1;
            while (n7 < n4) {
                if (n7 < this.unitsInUse) {
                    this.bits[n7] = 0L;
                }
                ++n7;
            }
        }
        if (n4 < this.unitsInUse) {
            l = BitSet.bitsRightOf(n2 & 0x3F);
            int n8 = n4;
            this.bits[n8] = this.bits[n8] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear() {
        while (this.unitsInUse > 0) {
            this.bits[--this.unitsInUse] = 0L;
        }
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        boolean bl = false;
        int n2 = BitSet.unitIndex(n);
        if (n2 < this.unitsInUse) {
            bl = (this.bits[n2] & BitSet.bit(n)) != 0L;
        }
        return bl;
    }

    public BitSet get(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
        if (this.length() <= n || n == n2) {
            return new BitSet(0);
        }
        if (this.length() < n2) {
            n2 = this.length();
        }
        BitSet bitSet = new BitSet(n2 - n);
        int n3 = n & 0x3F;
        int n4 = n2 & 0x3F;
        int n5 = (n2 - n + 63) / 64;
        int n6 = BitSet.unitIndex(n2) - BitSet.unitIndex(n) + 1;
        int n7 = 64 - n3;
        int n8 = 0;
        int n9 = BitSet.unitIndex(n);
        while (n8 < n5 - 1) {
            bitSet.bits[n8++] = this.bits[n9++] >>> n3 | (n7 == 64 ? 0L : this.bits[n9] << n7);
        }
        bitSet.bits[n8] = n6 == n5 ? (this.bits[n9] & BitSet.bitsRightOf(n4)) >>> n3 : this.bits[n9++] >>> n3 | (n7 == 64 ? 0L : (this.getBits(n9) & BitSet.bitsRightOf(n4)) << n7);
        bitSet.unitsInUse = n5;
        bitSet.recalculateUnitsInUse();
        return bitSet;
    }

    private long getBits(int n) {
        return n < this.unitsInUse ? this.bits[n] : 0L;
    }

    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        if (n2 >= this.unitsInUse) {
            return -1;
        }
        int n3 = n & 0x3F;
        long l = this.bits[n2] >> n3;
        if (l == 0L) {
            n3 = 0;
        }
        while (l == 0L && n2 < this.unitsInUse - 1) {
            l = this.bits[++n2];
        }
        if (l == 0L) {
            return -1;
        }
        return n2 * 64 + (n3 += BitSet.trailingZeroCnt(l));
    }

    private static int trailingZeroCnt(long l) {
        int n = (int)l & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n];
        }
        n = (int)(l >>> 8) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 8;
        }
        n = (int)(l >>> 16) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 16;
        }
        n = (int)(l >>> 24) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 24;
        }
        n = (int)(l >>> 32) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 32;
        }
        n = (int)(l >>> 40) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 40;
        }
        n = (int)(l >>> 48) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 48;
        }
        n = (int)(l >>> 56) & 0xFF;
        return trailingZeroTable[n] + 56;
    }

    public int nextClearBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        if (n2 >= this.unitsInUse) {
            return n;
        }
        int n3 = n & 0x3F;
        long l = this.bits[n2] >> n3;
        if (l == -1L >> n3) {
            n3 = 0;
        }
        while (l == -1L && n2 < this.unitsInUse - 1) {
            l = this.bits[++n2];
        }
        if (l == -1L) {
            return this.length();
        }
        if (l == 0L) {
            return n2 * 64 + n3;
        }
        return n2 * 64 + (n3 += BitSet.trailingZeroCnt(l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public int length() {
        if (this.unitsInUse == 0) {
            return 0;
        }
        long l = this.bits[this.unitsInUse - 1];
        int n = (int)(l >>> 32);
        return 64 * (this.unitsInUse - 1) + (n == 0 ? BitSet.bitLen((int)l) : 32 + BitSet.bitLen(n));
    }

    private static int bitLen(int n) {
        return n < 32768 ? (n < 128 ? (n < 8 ? (n < 2 ? (n < 1 ? (n < 0 ? 32 : 0) : 1) : (n < 4 ? 2 : 3)) : (n < 32 ? (n < 16 ? 4 : 5) : (n < 64 ? 6 : 7))) : (n < 2048 ? (n < 512 ? (n < 256 ? 8 : 9) : (n < 1024 ? 10 : 11)) : (n < 8192 ? (n < 4096 ? 12 : 13) : (n < 16384 ? 14 : 15)))) : (n < 0x800000 ? (n < 524288 ? (n < 131072 ? (n < 65536 ? 16 : 17) : (n < 262144 ? 18 : 19)) : (n < 0x200000 ? (n < 0x100000 ? 20 : 21) : (n < 0x400000 ? 22 : 23))) : (n < 0x8000000 ? (n < 0x2000000 ? (n < 0x1000000 ? 24 : 25) : (n < 0x4000000 ? 26 : 27)) : (n < 0x20000000 ? (n < 0x10000000 ? 28 : 29) : (n < 0x40000000 ? 30 : 31))));
    }

    public boolean isEmpty() {
        return this.unitsInUse == 0;
    }

    public boolean intersects(BitSet bitSet) {
        int n = Math.min(this.unitsInUse, bitSet.unitsInUse) - 1;
        while (n >= 0) {
            if ((this.bits[n] & bitSet.bits[n]) != 0L) {
                return true;
            }
            --n;
        }
        return false;
    }

    public int cardinality() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.unitsInUse) {
            n += BitSet.bitCount(this.bits[n2]);
            ++n2;
        }
        return n;
    }

    public int unusedUnits() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.unitsInUse) {
            if (BitSet.bitCount(this.bits[n2]) == 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getUnitsInUse() {
        return this.unitsInUse;
    }

    private static int bitCount(long l) {
        l -= (l & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        l = (l & 0x3333333333333333L) + (l >>> 2 & 0x3333333333333333L);
        l = l + (l >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l += l >>> 8;
        l += l >>> 16;
        return (int)l + (int)(l >>> 32) & 0xFF;
    }

    public void and(BitSet bitSet) {
        if (this == bitSet) {
            return;
        }
        int n = this.unitsInUse;
        this.unitsInUse = Math.min(this.unitsInUse, bitSet.unitsInUse);
        int n2 = 0;
        while (n2 < this.unitsInUse) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & bitSet.bits[n2];
            ++n2;
        }
        while (n2 < n) {
            this.bits[n2] = 0L;
            ++n2;
        }
        if (this.unitsInUse > 0 && this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void or(BitSet bitSet) {
        if (this == bitSet) {
            return;
        }
        this.ensureCapacity(bitSet.unitsInUse);
        int n = Math.min(this.unitsInUse, bitSet.unitsInUse);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] | bitSet.bits[n2];
            ++n2;
        }
        while (n2 < bitSet.unitsInUse) {
            this.bits[n2] = bitSet.bits[n2];
            ++n2;
        }
        if (this.unitsInUse < bitSet.unitsInUse) {
            this.unitsInUse = bitSet.unitsInUse;
        }
    }

    public void xor(BitSet bitSet) {
        int n;
        int n2;
        if (this.unitsInUse >= bitSet.unitsInUse) {
            n2 = bitSet.unitsInUse;
        } else {
            n2 = this.unitsInUse;
            n = bitSet.unitsInUse;
            this.ensureCapacity(n);
            this.unitsInUse = n;
        }
        n = 0;
        while (n < n2) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] ^ bitSet.bits[n];
            ++n;
        }
        while (n < bitSet.unitsInUse) {
            this.bits[n] = bitSet.bits[n];
            ++n;
        }
        this.recalculateUnitsInUse();
    }

    public void andNot(BitSet bitSet) {
        int n = Math.min(this.unitsInUse, bitSet.unitsInUse);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & (bitSet.bits[n2] ^ 0xFFFFFFFFFFFFFFFFL);
            ++n2;
        }
        this.recalculateUnitsInUse();
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitSet)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BitSet bitSet = (BitSet)object;
        int n = Math.min(this.unitsInUse, bitSet.unitsInUse);
        int n2 = 0;
        while (n2 < n) {
            if (this.bits[n2] != bitSet.bits[n2]) {
                return false;
            }
            ++n2;
        }
        if (this.unitsInUse > n) {
            n2 = n;
            while (n2 < this.unitsInUse) {
                if (this.bits[n2] != 0L) {
                    return false;
                }
                ++n2;
            }
        } else {
            n2 = n;
            while (n2 < bitSet.unitsInUse) {
                if (bitSet.bits[n2] != 0L) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public Object clone() {
        BitSet bitSet = null;
        try {
            bitSet = (BitSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        bitSet.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bitSet.bits, 0, this.unitsInUse);
        return bitSet;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.unitsInUse = this.bits.length;
        this.recalculateUnitsInUse();
    }

    public String toString() {
        int n = this.unitsInUse << 6;
        StringBuffer stringBuffer = new StringBuffer(8 * n + 2);
        String string = "";
        stringBuffer.append('{');
        int n2 = 0;
        while (n2 < n) {
            if (this.get(n2)) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(n2);
            }
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

