/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.ListCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CoWList
implements List {
    public static final ListCreator ARRAY_LIST = new ArrayCreator();
    public static final ListCreator LINKED_LIST = new LinkedCreator();
    private volatile List l;
    private final ListCreator creator;
    private final Object lock;

    public CoWList(List list, Object object) {
        this.l = list;
        this.creator = new ReflectiveCreator(list.getClass());
        this.lock = object == null ? this : object;
    }

    public CoWList(Class clazz, Object object) {
        this(new ReflectiveCreator(clazz), object);
    }

    public CoWList(ListCreator listCreator) {
        this(listCreator, null);
    }

    public CoWList(ListCreator listCreator, Object object) {
        this.creator = listCreator;
        this.l = listCreator.getList();
        this.lock = object == null ? this : object;
    }

    private List getListCopy() {
        List list = this.creator.getList();
        if (this.l != null) {
            list.addAll(this.l);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            List list = this.getListCopy();
            list.add(n, object);
            this.l = list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            List list = this.getListCopy();
            boolean bl = list.add(object);
            this.l = list;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        Object object = this.lock;
        synchronized (object) {
            List list = this.getListCopy();
            boolean bl = list.addAll(collection);
            this.l = list;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int n, Collection collection) {
        Object object = this.lock;
        synchronized (object) {
            List list = this.getListCopy();
            boolean bl = list.addAll(n, collection);
            this.l = list;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            List list = this.getListCopy();
            list.clear();
            this.l = list;
        }
    }

    public boolean contains(Object object) {
        return this.l.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.l.containsAll(collection);
    }

    public Object get(int n) {
        return this.l.get(n);
    }

    public int indexOf(Object object) {
        return this.l.indexOf(object);
    }

    public boolean isEmpty() {
        return this.l.isEmpty();
    }

    public Iterator iterator() {
        return this.l.iterator();
    }

    public int lastIndexOf(Object object) {
        return this.l.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.l.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.l.listIterator(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int n) {
        Object object = this.lock;
        synchronized (object) {
            Object var3_3 = null;
            List list = this.getListCopy();
            var3_3 = list.remove(n);
            this.l = list;
            return var3_3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            List list = this.getListCopy();
            boolean bl = list.remove(object);
            this.l = list;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        Object object = this.lock;
        synchronized (object) {
            List list = this.getListCopy();
            boolean bl = list.removeAll(collection);
            this.l = list;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        Object object = this.lock;
        synchronized (object) {
            List list = this.getListCopy();
            boolean bl = list.retainAll(collection);
            this.l = list;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int n, Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            List list = this.getListCopy();
            Object object3 = list.set(n, object);
            this.l = list;
            return object3;
        }
    }

    public int size() {
        return this.l.size();
    }

    public List subList(int n, int n2) {
        return this.l.subList(n, n2);
    }

    public Object[] toArray() {
        return this.l.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.l.toArray(objectArray);
    }

    public String toString() {
        return this.l.toString();
    }

    private static class ReflectiveCreator
    implements ListCreator {
        private final Class listType;

        public ReflectiveCreator(Class clazz) {
            this.listType = clazz;
        }

        public List getList() {
            List list = null;
            try {
                list = (List)this.listType.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorService.error(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                ErrorService.error(instantiationException);
            }
            return list;
        }
    }

    private static class ArrayCreator
    implements ListCreator {
        private ArrayCreator() {
        }

        public List getList() {
            return new ArrayList();
        }
    }

    private static class LinkedCreator
    implements ListCreator {
        private LinkedCreator() {
        }

        public List getList() {
            return new LinkedList();
        }
    }
}

