/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.I18NConvert;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    private static final List TRIVIAL_WORDS = new ArrayList(3);
    private static final Collator COLLATOR;

    static {
        TRIVIAL_WORDS.add("the");
        TRIVIAL_WORDS.add("an");
        TRIVIAL_WORDS.add("a");
        TRIVIAL_WORDS.add("and");
        COLLATOR = Collator.getInstance(new Locale(ApplicationSettings.LANGUAGE.getValue(), ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LOCALE_VARIANT.getValue()));
        COLLATOR.setDecomposition(2);
        COLLATOR.setStrength(0);
    }

    public static final boolean contains(String string, String string2) {
        return StringUtils.contains(string, string2, false);
    }

    public static final boolean contains(String string, String string2, boolean bl) {
        int n = string2.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5 = 32;
            int n6 = n3;
            while (n6 < n) {
                n4 = string2.charAt(n6);
                if (n4 == 32 || n4 == 43 || n4 == 42) {
                    n5 = n4;
                    break;
                }
                ++n6;
            }
            n4 = StringUtils.subset(string2, n3, n6, string, n2, bl);
            if (n4 < 0) {
                return false;
            }
            if (n5 == 32 || n5 == 43) {
                n2 = 0;
            } else if (n5 == 42) {
                n2 = n4 + n6 - n3;
            }
            n3 = n6 + 1;
        }
        return true;
    }

    public static boolean containsCharacters(String string, char[] cArray) {
        char[] cArray2 = string.toCharArray();
        Arrays.sort(cArray2);
        int n = 0;
        while (n < cArray.length) {
            if (Arrays.binarySearch(cArray2, cArray[n]) >= 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final int subset(String string, int n, int n2, String string2, int n3, boolean bl) {
        if (bl) {
            int n4 = string2.length() - (n2 - n) + 1;
            int n5 = n3;
            while (n5 < n4) {
                block7: {
                    int n6 = n2 - n;
                    int n7 = 0;
                    while (n7 < n6) {
                        char c;
                        char c2 = string2.charAt(n5 + n7);
                        if (c2 == (c = string.charAt(n + n7)) || c2 == StringUtils.toOtherCase(c)) {
                            ++n7;
                            continue;
                        }
                        break block7;
                    }
                    return n5;
                }
                ++n5;
            }
            return -1;
        }
        int n8 = string2.length() - (n2 - n) + 1;
        int n9 = n3;
        while (n9 < n8) {
            block8: {
                int n10 = n2 - n;
                int n11 = 0;
                while (n11 < n10) {
                    char c;
                    char c3 = string2.charAt(n9 + n11);
                    if (c3 == (c = string.charAt(n + n11))) {
                        ++n11;
                        continue;
                    }
                    break block8;
                }
                return n9;
            }
            ++n9;
        }
        return -1;
    }

    public static final char toOtherCase(char c) {
        char c2 = c;
        if (c2 < 'A') {
            return c;
        }
        if (c2 <= 'Z') {
            return (char)(c2 + 32);
        }
        if (c2 < 'a') {
            return c;
        }
        if (c2 <= 'z') {
            return (char)(c2 - 32);
        }
        return c;
    }

    public static String[] split(String string, char c) {
        return StringUtils.split(string, String.valueOf(c));
    }

    public static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.get(n);
            ++n;
        }
        return stringArray;
    }

    public static String[] splitNoCoalesce(String string, char c) {
        return StringUtils.splitNoCoalesce(string, String.valueOf(c));
    }

    public static String[] splitNoCoalesce(String string, String string2) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        Vector<Object> vector = new Vector<Object>();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (stringArray.length() == 1 && string2.indexOf((String)stringArray) >= 0) {
                if (bl) {
                    vector.add("");
                }
                bl = true;
                continue;
            }
            vector.add(stringArray);
            bl = false;
        }
        if (bl && !vector.isEmpty()) {
            vector.add("");
        }
        stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.get(n);
            ++n;
        }
        return stringArray;
    }

    public static int compareIgnoreCase(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        int n4 = 0;
        while (n4 < n3) {
            char c;
            char c2 = string.charAt(n4);
            if (c2 != (c = string2.charAt(n4)) && (c2 = Character.toUpperCase(c2)) != (c = Character.toUpperCase(c)) && (c2 = Character.toLowerCase(c2)) != (c = Character.toLowerCase(c))) {
                return c2 - c;
            }
            ++n4;
        }
        return n - n2;
    }

    public static int compareFullPrimary(String string, String string2) {
        return COLLATOR.compare(string, string2);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        int n = string2.length();
        if (string.length() < n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 != (c = string2.charAt(n2)) && (c2 = Character.toUpperCase(c2)) != (c = Character.toUpperCase(c)) && (c2 = Character.toLowerCase(c2)) != (c = Character.toLowerCase(c))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String getEntriesAsString(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(e.toString());
        }
        return stringBuffer.toString();
    }

    public static Set getSetofValues(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.indexOf(string2);
        while (n2 > -1) {
            if (n2 > n) {
                stringBuffer.append(string.substring(n, n2));
            }
            stringBuffer.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n2 + 1);
        }
        stringBuffer.append(string.substring(n, string.length()));
        return stringBuffer.toString();
    }

    public static String truncate(String string, int n) {
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return string.toLowerCase().indexOf(string2.toLowerCase());
    }

    public static String createQueryString(String string) {
        return StringUtils.createQueryString(string, false);
    }

    public static String createQueryString(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        String string2 = null;
        string = I18NConvert.instance().getNorm(string);
        int n = SearchSettings.MAX_QUERY_LENGTH.getValue();
        Set set = StringUtils.keywords(string, bl);
        if (set.size() < 1) {
            string2 = StringUtils.removeIllegalChars(string);
            string2 = StringUtils.truncate(string2, n);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && n2 < n) {
                String string3 = (String)iterator.next();
                if (n2 + string3.length() >= n) continue;
                if (n2 > 0) {
                    stringBuffer.append(" ");
                    ++n2;
                }
                stringBuffer.append(string3);
                n2 += string3.length();
            }
            string2 = stringBuffer.toString();
            if (string2.equals("")) {
                string2 = StringUtils.truncate(string, n);
            }
        }
        Assert.that(string2.length() <= n, "Original filename: " + string + ", converted: " + string2);
        if (!set.isEmpty()) {
            Assert.that(!string2.equals(""), "Original filename: " + string);
        }
        Assert.that(string2 != null, "Original filename: " + string);
        return string2;
    }

    public static final String removeIllegalChars(String string) {
        String string2 = "";
        String string3 = " -._+/*()\\,";
        char[] cArray = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuffer stringBuffer = new StringBuffer(string3.length() + cArray.length);
        stringBuffer.append(cArray).append(" -._+/*()\\,");
        StringTokenizer stringTokenizer = new StringTokenizer(string, stringBuffer.toString());
        while (stringTokenizer.hasMoreTokens()) {
            string2 = String.valueOf(string2) + stringTokenizer.nextToken().trim() + " ";
        }
        return string2.trim();
    }

    public static final Set keywords(String string) {
        return StringUtils.keywords(string, false);
    }

    public static final Set keywords(String string, boolean bl) {
        string = StringUtils.ripExtension(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string2 = " -._+/*()\\,";
        char[] cArray = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuffer stringBuffer = new StringBuffer(string2.length() + cArray.length);
        stringBuffer.append(cArray).append(" -._+/*()\\,");
        StringTokenizer stringTokenizer = new StringTokenizer(string, stringBuffer.toString());
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toLowerCase();
            try {
                Double.valueOf(string3);
                if (!bl) {
                    continue;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (TRIVIAL_WORDS.contains(string3)) continue;
            linkedHashSet.add(string3);
        }
        return linkedHashSet;
    }

    public static String ripExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }
}

