/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.TrieEdge;
import com.limegroup.gnutella.util.TrieNode;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public class Trie {
    private TrieNode root;
    private boolean ignoreCase;
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    public Trie(boolean bl) {
        this.ignoreCase = bl;
        this.clear();
    }

    public void clear() {
        this.root = new TrieNode();
    }

    public String canonicalCase(String string) {
        if (!this.ignoreCase) {
            return string;
        }
        return string.toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    private final int match(String string, int n, int n2, String string2) {
        int n3 = n;
        int n4 = 0;
        while (n4 < string2.length()) {
            if (n3 >= n2) {
                return n4;
            }
            if (string.charAt(n3) != string2.charAt(n4)) {
                return n4;
            }
            ++n3;
            ++n4;
        }
        return -1;
    }

    public Object add(String string, Object object) {
        Object object2;
        string = this.canonicalCase(string);
        TrieNode trieNode = this.root;
        int n = 0;
        while (n < string.length()) {
            Object object3;
            object2 = trieNode.get(string.charAt(n));
            if (object2 == null) {
                object3 = new TrieNode(object);
                trieNode.put(string.substring(n), (TrieNode)object3);
                return null;
            }
            object3 = ((TrieEdge)object2).getLabel();
            int n2 = this.match(string, n, string.length(), (String)object3);
            Assert.that(n2 != 0, "Label didn't start with prefix[0].");
            if (n2 >= 0) {
                TrieNode trieNode2 = ((TrieEdge)object2).getChild();
                TrieNode trieNode3 = new TrieNode();
                String string2 = ((String)object3).substring(0, n2);
                String string3 = ((String)object3).substring(n2);
                String string4 = string.substring(n + n2);
                if (string4.length() > 0) {
                    TrieNode trieNode4 = new TrieNode(object);
                    trieNode.remove(((String)object3).charAt(0));
                    trieNode.put(string2, trieNode3);
                    trieNode3.put(string3, trieNode2);
                    trieNode3.put(string4, trieNode4);
                } else {
                    trieNode.remove(((String)object3).charAt(0));
                    trieNode.put(string2, trieNode3);
                    trieNode3.put(string3, trieNode2);
                    trieNode3.setValue(object);
                }
                return null;
            }
            Assert.that(n2 == -1, "Bad return value from match: " + n);
            trieNode = ((TrieEdge)object2).getChild();
            n += ((String)object3).length();
        }
        object2 = trieNode.getValue();
        trieNode.setValue(object);
        return object2;
    }

    private TrieNode fetch(String string) {
        TrieNode trieNode = this.root;
        int n = 0;
        while (n < string.length()) {
            TrieEdge trieEdge = trieNode.get(string.charAt(n));
            if (trieEdge == null) {
                return null;
            }
            String string2 = trieEdge.getLabel();
            int n2 = this.match(string, n, string.length(), string2);
            Assert.that(n2 != 0, "Label didn't start with prefix[0].");
            if (n2 != -1) {
                return null;
            }
            n += string2.length();
            trieNode = trieEdge.getChild();
        }
        return trieNode;
    }

    public Object get(String string) {
        TrieNode trieNode = this.fetch(string = this.canonicalCase(string));
        if (trieNode == null) {
            return null;
        }
        return trieNode.getValue();
    }

    public boolean remove(String string) {
        TrieNode trieNode = this.fetch(string = this.canonicalCase(string));
        if (trieNode == null) {
            return false;
        }
        boolean bl = trieNode.getValue() != null;
        trieNode.setValue(null);
        return bl;
    }

    public Iterator getPrefixedBy(String string) {
        string = this.canonicalCase(string);
        return this.getPrefixedBy(string, 0, string.length());
    }

    public Iterator getPrefixedBy(String string, int n, int n2) {
        TrieNode trieNode = this.root;
        int n3 = n;
        while (n3 < n2) {
            TrieEdge trieEdge = trieNode.get(string.charAt(n3));
            if (trieEdge == null) {
                return EMPTY_ITERATOR;
            }
            trieNode = trieEdge.getChild();
            String string2 = trieEdge.getLabel();
            int n4 = this.match(string, n3, n2, string2);
            Assert.that(n4 != 0, "Label didn't start with prefix[0].");
            if (n3 + n4 == n2) break;
            if (n4 >= 0) {
                trieNode = null;
                break;
            }
            Assert.that(n4 == -1, "Bad return value from match: " + n3);
            n3 += string2.length();
        }
        if (trieNode == null) {
            return EMPTY_ITERATOR;
        }
        return new ValueIterator(trieNode);
    }

    public Iterator getIterator() {
        return new ValueIterator(this.root);
    }

    public void trim(Function function) throws IllegalArgumentException, ClassCastException {
        if (function != null) {
            NodeIterator nodeIterator = new NodeIterator(this.root, true);
            while (nodeIterator.hasNext()) {
                TrieNode trieNode = (TrieNode)nodeIterator.next();
                trieNode.trim();
                Object object = trieNode.getValue();
                if (object == null) continue;
                trieNode.setValue(function.apply(object));
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<root>");
        this.toStringHelper(this.root, stringBuffer, 1);
        return stringBuffer.toString();
    }

    private void toStringHelper(TrieNode trieNode, StringBuffer stringBuffer, int n) {
        if (trieNode.getValue() != null) {
            stringBuffer.append(" -> ");
            stringBuffer.append(trieNode.getValue().toString());
        }
        stringBuffer.append("\n");
        Iterator iterator = trieNode.labelsForward();
        while (iterator.hasNext()) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(" ");
                ++n2;
            }
            String string = (String)iterator.next();
            stringBuffer.append(string);
            TrieNode trieNode2 = trieNode.get(string.charAt(0)).getChild();
            this.toStringHelper(trieNode2, stringBuffer, n + 1);
        }
    }

    private class ValueIterator
    extends NodeIterator {
        ValueIterator(TrieNode trieNode) {
            super(trieNode, false);
        }

        public Object next() {
            return ((TrieNode)super.next()).getValue();
        }
    }

    private static class EmptyIterator
    extends UnmodifiableIterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    }

    public class NodeIterator
    extends UnmodifiableIterator {
        private ArrayList stack = new ArrayList();
        private boolean withNulls;

        public NodeIterator(TrieNode trieNode, boolean bl) {
            this.withNulls = bl;
            if (bl || trieNode.getValue() != null) {
                this.stack.add(trieNode);
            } else {
                this.advance(trieNode);
            }
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public Object next() {
            int n = this.stack.size();
            if (n == 0) {
                throw new NoSuchElementException();
            }
            TrieNode trieNode = (TrieNode)this.stack.remove(n - 1);
            this.advance(trieNode);
            return trieNode;
        }

        private void advance(TrieNode trieNode) {
            Iterator iterator = trieNode.childrenForward();
            while (true) {
                if (iterator.hasNext()) {
                    trieNode = (TrieNode)iterator.next();
                    if (iterator.hasNext()) {
                        this.stack.add(iterator);
                    }
                    if (this.withNulls || trieNode.getValue() == null) {
                        iterator = trieNode.childrenForward();
                        continue;
                    }
                    this.stack.add(trieNode);
                    return;
                }
                int n = this.stack.size();
                if (n == 0) {
                    return;
                }
                iterator = (Iterator)this.stack.remove(n - 1);
            }
        }
    }
}

