/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LimeXMLSchemaRepository {
    private Map _uriSchemaMap = new HashMap();
    private static LimeXMLSchemaRepository _instance = new LimeXMLSchemaRepository();

    private LimeXMLSchemaRepository() {
        this.initialize();
    }

    protected void initialize() {
        File[] fileArray = LimeXMLProperties.instance().getAllXMLSchemaFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                try {
                    LimeXMLSchema limeXMLSchema = new LimeXMLSchema(fileArray[n]);
                    this._uriSchemaMap.put(limeXMLSchema.getSchemaURI(), limeXMLSchema);
                }
                catch (IOException iOException) {}
                ++n;
            }
        }
    }

    public static LimeXMLSchemaRepository instance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLSchema getSchema(String string) {
        Map map = this._uriSchemaMap;
        synchronized (map) {
            return (LimeXMLSchema)this._uriSchemaMap.get(string);
        }
    }

    public Collection getAvailableSchemas() {
        return Collections.unmodifiableCollection(this._uriSchemaMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableSchemaURIs() {
        Object[] objectArray;
        Map map = this._uriSchemaMap;
        synchronized (map) {
            Set set = this._uriSchemaMap.keySet();
            objectArray = set.toArray(new String[0]);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }
}

