<?php
/**
* PHP饯饹
*
* PHP version 5
*
* @version    0.1
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
* @license    http://www.opensource.org/licenses/mit-license.php MIT License
*/

require_once( 'PhpSourceElement.class.php' );

class PhpSourceRenderer
{
	/**
	 *	
	 *
	 *	@return string 󥰷̡HTML
	 */
	public static function render( $tokens, $number_format = NULL, $classes = array() )
	{
		$class = isset($classes['source_code']) ? $classes['source_code'] : 'source_code';
		$html = "<pre class=\"$class\">";

		$rows = count($tokens);
		for( $i=1; $i<$rows; $i++ ){
			// 
			$even_odd = (($i % 2) === 0) ? 'even' : 'odd';
			$class = isset($classes[$even_odd]) ? $classes[$even_odd] : $even_odd;
			$html .= "<div class=\"$class\">";
			// ֹ
			if ( $number_format ){
				$class = isset($classes['line_no']) ? $classes['line_no'] : 'line_no';
				$line_no = sprintf( $number_format, $i );
				$html .= "<span class=\"$class\">$line_no</span>";
			}
			// 
			$tokens_line = $tokens[$i];
			$cnt = count($tokens_line);
			for( $j=0; $j<$cnt; $j++ ){
				$token = $tokens_line[$j];
				$token = $token;
				$code = htmlspecialchars($token->getCode());
				$type = $token->getType();
				switch( $type ){
				case PhpSourceElement::TYPE_KEYWORD:		$type = 'keyword';			break;
				case PhpSourceElement::TYPE_IDENTIFIER:		$type = 'identifier';		break;
				case PhpSourceElement::TYPE_COMMENT:		$type = 'comment';			break;
				case PhpSourceElement::TYPE_DELIMITER:		$type = 'delimiter';		break;
				case PhpSourceElement::TYPE_CONST_STRING:	$type = 'const_string';		break;
				}
				$class = isset($classes[$type]) ? $classes[$type] : $type;
				$html .= "<span class=\"$class\">$code</span>";
			}
			$html .= "</div>";
		}
		$html .= "</pre>";

		return $html;
	}


}
