/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm;

import java.util.ArrayList;
import java.util.List;

/**
 * ssoadm の結果情報.
 */
public class SsoadmResult {

    /**
     * SsoadmResultの処理結果コード（成功）
     */
    public static final int EXITCODE_SUCCESS = 0;

    /**
     * SsoadmResultの処理結果コード（失敗）
     */
    public static final int EXITCODE_FAILURE = -1;

    /**
     * データ.
     */
    private List<String> data;

    /**
     * 終了コード.
     */
    private int exitCode;

    /**
     * データを取得します.
     * 
     * @return データ.
     * 
     */
    public List<String> getData() {
        return data;
    }

    /**
     * 終了コードを取得します.
     * 
     * @return 終了コード.
     * 
     */
    public int getExitCode() {
        return this.exitCode;
    }

    /**
     * コンストラクタ.
     */
    public SsoadmResult(List<String> data, int exitCode) {
        super();
        this.data = data != null ? data : new ArrayList<String>();
        this.exitCode = toSsoadmResultcode(exitCode);
    }

    /**
     * ssoadmの実行結果コードをSsoadmResultの結果コードに変換する.
     * 
     * @param exitCode ssoadmの実行結果コード.
     * 
     * @return soadmResultの結果コード.
     */
    private int toSsoadmResultcode(int exitCode) {
        int result;

        switch (exitCode) {
        case 0:
            result = EXITCODE_SUCCESS;
            break;

        default:
            result = exitCode;
            break;
        }
        return result;
    }
}
