/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel;

import java.util.List;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

/**
 * ファイルにExcelPolicyを書き込むインターフェース.
 * 
 */
public interface ExcelPolicyWriter {
    /**
     * ポリシー定義を指定されたファイル名のEXCEL形式のファイルで出力する.
     * 
     * @param fileName ファイル名.
     * @param policies 出力対象のポリシーリスト.
     */
    void write(String fileName, List<Policy> policies);
}
