/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * 
 */
package jp.co.ogis_ri.citk.policytool.common.exception;

import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;

/**
 * ポリシーを読み込む際の例外.
 * 
 */
public class ExcelPolicyReadException extends ApplicationException {

    /**
     * シリアルバージョン番号.
     */
    private static final long serialVersionUID = 1L;

    /**
     * ポリシーの読み込み元のファイル名.
     */
    private String fileName;

    /**
     * ポリシーの読み込み元のファイル名を取得する.
     * 
     * @return ポリシーの読み込み元のファイル名.
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * コンストラクタ.
     * 
     * @param messageInfo MessageInfo.
     */
    public ExcelPolicyReadException(MessageInfo messageInfo) {
        super(messageInfo);
    }

    /**
     * コンストラクタ.
     * 
     * @param messageInfo MessageInfo.
     * @param cause この例外の原因となった例外.
     */
    public ExcelPolicyReadException(MessageInfo messageInfo, Throwable cause) {
        super(messageInfo, cause);
    }

    /**
     * コンストラクタ.
     * 
     * @param fileName ポリシーの書き込み先のファイル名.
     * @param code メッセージコード.
     * @param args メッセージ生成に使用する追加情報.
     */
    public ExcelPolicyReadException(String fileName, String code,
            Object... args) {
        super(code, args);
        this.fileName = fileName;
    }

    /**
     * コンストラクタ.
     * 
     * @param fileName ポリシーの書き込み先のファイル名.
     * @param cause この例外の原因となった例外.
     * @param code メッセージコード.
     * @param args メッセージ生成に使用する追加情報.
     */
    public ExcelPolicyReadException(String fileName, Throwable cause,
            String code, Object... args) {
        super(cause, code, args);
        this.fileName = fileName;
    }

}
