/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.model;

import java.io.Serializable;

import javax.persistence.MappedSuperclass;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 抽象的なエンティティクラス.
 * 
 * @author michio
 * 
 * @param <K>　主キー型
 */
@MappedSuperclass
public abstract class AbstractModel<K extends Serializable> implements
        Serializable {
    /**
     * シリアルバージョン番号.
     */
    private static final long serialVersionUID = 1L;

    /**
     * IDを取得する.
     * 
     * @return ID.
     */
    public abstract K getId();

    /**
     * モデルが新しいか,そうでないかを判断する.
     * 
     * @return モデルが新しい場合true, そうでない場合false.
     */
    public boolean isNew() {
        return getId() == null;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other)
            return true;
        if (other == null)
            return false;
        if (!getClass().isAssignableFrom(other.getClass()))
            return false;

        AbstractModel<?> otherEntity = (AbstractModel<?>) other;
        return ObjectUtils.equals(getId(), otherEntity.getId());
    }

    @Override
    public int hashCode() {
        if (isNew())
            return System.identityHashCode(this);

        assert getId() != null;

        return getId().hashCode();
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this,
                ToStringStyle.DEFAULT_STYLE);
    }
}
