/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.resource;

import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;

/**
 * コードに対応するメッセージを取得し、コードとメッセージを格納する.
 * 
 * @author NAKAGAWA michio
 * 
 */
public class MessageInfo {
    /**
     * コード.
     */
    private String code;

    /**
     * メッセージ.
     */
    private String message;

    /**
     * コードを取得する.
     * 
     * @return コード.
     */
    public String getCode() {
        return code;
    }

    /**
     * メッセージを取得する.
     * 
     * @return メッセージ.
     */
    public String getMessage() {
        return message;
    }

    /**
     * コンストラクタ.
     * 
     * @param code コード.
     * @param args コードに対応するリソースに対しての引数.
     */
    public MessageInfo(String code, Object... args) {
        super();
        this.code = code;
        this.message =
                ApplicationContextUtil.getResources().getMessage(code, args);
    }

    @Override
    public String toString() {
        return "[" + code + "]:" + message;
    }
}
