/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.util.Properties;

import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.MessageSourceAccessor;

/**
 * ApplicationContextに関する処理のユーティリティクラス.
 * 
 */
public class ApplicationContextUtil {
    /**
     * ApplicationContext.xmlのファイル名.
     */
    private static String FILE_APPLICATION_CONTEXT = "applicationContext.xml";

    /**
     * プロパティのID.
     */
    private static String ID_PROPERTIES = "policytoolProperty";

    /**
     * メッセージリソースアクセサのID.
     */
    private static String ID_RESOURCES = "messageSourceAccessor";

    /**
     * ApplicationContext.
     */
    private static ApplicationContext context = null;

    /**
     * コンストラクタ.
     */
    private ApplicationContextUtil() {
    }

    /**
     * ApplicationContextを取得する.
     * 
     * @return ApplicationContext.
     */
    public static ApplicationContext getContext() {
        if (context == null) {
            context =
                    new ClassPathXmlApplicationContext(
                            new String[] {FILE_APPLICATION_CONTEXT});
        }
        return context;
    }

    /**
     * 指定されたIDのオブジェクトを取得する.
     * 
     * @param id ID.
     * @return 指定されたIDのオブジェクト.
     */
    public static Object getBean(String id) {
        if (!getContext().containsBean(id)) {
            throw new SystemException("Not found spring bean id: " + id);
        }
        return getContext().getBean(id);
    }

    /**
     * 指定されたクラスのオブジェクトを取得する.
     * 
     * @param clazz クラス.
     * @return 指定されたクラスのオブジェクト.
     */
    public static <T> T getBean(Class<T> clazz) {
        return getContext().getBean(clazz);
    }

    /**
     * Properties を取得する.
     * 
     * @return Properties.
     */
    public static Properties getProperties() {
        return (Properties) getBean(ID_PROPERTIES);
    }

    /**
     * リソースへのアクセスクラスである, MessageSourceAccessorを取得する.
     * 
     * @return MessageSourceAccessor.
     */
    public static MessageSourceAccessor getResources() {
        return (MessageSourceAccessor) getBean(ID_RESOURCES);
    }
}
