/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Manifest;

import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;

import org.apache.commons.logging.Log;

/**
 * JARのMANIFESTを処理するユーティリティクラス.
 *
 */
public class ManifestUtl {
    /**
     * ロガー.
     */
    private static final Log logger =
            LogWrapperFactory.getLog(ManifestUtl.class);

    /**
     * コンストラクタ.
     */
    private ManifestUtl() {
    }

    /**
     * 指定したクラスが含まれるJARのMANIFESTを読み込む.
     * 
     * @param clazz JARに含まれるクラス
     * @return マニフェスト.
     */
    public static Manifest loadJAR(Class<?> clazz) {
        String s =
                clazz.getResource(clazz.getSimpleName() + ".class")
                        .toExternalForm();
        String jar =
                s.substring(
                        0,
                        s.lastIndexOf(clazz.getPackage()
                                .getName()
                                .replace('.', '/')));

        URL url = null;
        InputStream is = null;
        try {
            url = new URL(jar + "META-INF/MANIFEST.MF");
            is = url.openStream();
        } catch (MalformedURLException e) {
            logger.debug(e);
            throw ExceptionUtil.convertRuntimeException(e);
        } catch (IOException e) {
            logger.debug(e);
            throw ExceptionUtil.convertRuntimeException(e);
        }
        return loadJAR(is);
    }

    /**
     * 指定したクラスが含まれるJARのMANIFESTを読み込む.
     * 
     * @param is　マニフェストの入力ストリーム.
     * @return マニフェスト.
     */
    public static Manifest loadJAR(InputStream is) {
        Manifest mf = null;
        try {
            mf = new Manifest(is);
        } catch (IOException e) {
            logger.debug(e);
            throw ExceptionUtil.convertRuntimeException(e);
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                    // NOP
                }
            }
        }
        return mf;
    }

    /**
     * マニフェストの属性を取得する.
     * 
     * @param mf マニフェスト.
     * @param key 属性のキー.
     * @return 属性.
     */
    public static String getValue(Manifest mf, String key) {
        String value = null;
        try {
            value = mf.getMainAttributes().getValue(key);
        } catch (Exception e) {
            // NOP
        }
        return value == null ? "" : value;
    }
}
