/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * OpenAMで使用する名前に関する処理のユーティリティクラス.
 * 
 */
public class OpenAMNamingUtil {
    /** Values属性名 */
    public static final String VALUES_ATTR_NAME = "Values";

    /** サービス名　 */
    public static final String SERVICE_NAME = "iPlanetAMWebAgentService";

    /** サブジェクトIDの取得キー */
    public static final String SUBJECT_ID_KEY = "id";

    /** サブジェクトのタイプ　 */
    public static final String SUBJECT_TYPE = "AMIdentitySubject";

    /** サブジェクトのインクルードタイプ　 */
    public static final String SUBJECT_INCLUDE_TYPE = "inclusive";

    /** サブジェクト参照ポリシー のタイプ　 */
    public static final String SUBJECT_REFERRAL_TYPE = "SubOrgReferral";

    /** サブジェクト参照ポリシー のオーナーの取得キー　 */
    public static final String SUBJECT_REFERRAL_OWNER_KEY = "o";

    /** ルール内のGETメソッドの属性名 */
    public static final String RULE_ATTR_GETMETHOD_NAME = "GET";

    /** ルール内のPOSTメソッドの属性名 */
    public static final String RULE_ATTR_POSTMETHOD_NAME = "POST";

    /** Rule の名前のプレフィクス */
    private static final String RULE_NAME_PREFIX = "rule_";

    /** Subject の名前のプレフィクス */
    private static final String SUBJECT_NAME_PREFIX = "subject_";

    /** Subjects の名前のプレフィクス */
    private static final String SUBJECTS_NAME_PREFIX = "subjects_";

    /**
     * コンストラクタ.
     */
    private OpenAMNamingUtil() {
    }

    /**
     * OpenAMから返却されたモデルに含まれる値(Key-Valueの集まり)をKey-Value単位の要素にスプリットし、 Mapに変換する.
     * 
     * @param values OpenAMから返却された返却されたモデルに含まれる値.
     *            e.g.)id=group1,ou=group,dc=opensso,dc=java,dc=net
     * @return Key-Valueを収めたMap
     * 
     */
    public static Map<String, String> splitValue(String values) {
        Map<String, String> kv = new HashMap<String, String>();
        String[] items = values.split(",");
        for (String item : items) {
            String[] s = item.split("=");
            String key = s[0].trim();
            String value = s[1].trim();
            if (kv.containsKey(key)) {
                value = kv.get(key) + "," + value;
            }
            kv.put(key, value);
        }
        return kv;
    }

    /**
     * Ruleの名前UUID文字列を生成する.
     * 
     * @return 生成されたRuleの名前UUID文字列.
     */
    public static String generateRuleName() {
        return generateUUID(RULE_NAME_PREFIX);
    }

    /**
     * Subjectの名前UUID文字列を生成する.
     * 
     * @return 生成されたSubjectの名前UUID文字列.
     */
    public static String generateSubjectName() {
        return generateUUID(SUBJECT_NAME_PREFIX);
    }

    /**
     * Subjectsの名前UUID文字列を生成する.
     * 
     * @return 生成されたSubjectsの名前UUID文字列.
     */
    public static String generateSubjectsName() {
        return generateUUID(SUBJECTS_NAME_PREFIX);
    }

    /**
     * 指定された接頭辞を使用してランダムUUID文字列を生成する.
     * 
     * @param prefix 接頭辞.
     * @return 生成されたランダムUUID文字列.
     */
    private static String generateUUID(String prefix) {
        return prefix + UUID.randomUUID().toString();
    }
}
