/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * URL文字列の単項目チェックの検証アノテーション.
 * 
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = {})
@NotNull(message = "{jp.co.ogis_ri.citk.policytool.common.validation.annotation.Url.NotNull.message.default}")
@Size(min = 1, max = 255, message = "{jp.co.ogis_ri.citk.policytool.common.validation.annotation.Url.Size.message.default}")
@Pattern(regexp = "http(s)?://([\\w-]+\\.)*[\\w-]+(:[0-9*]+)?(/[\\w- ./?%&=]*)?[*]?", message = "{jp.co.ogis_ri.citk.policytool.common.validation.annotation.Url.Pattern.message.default}")
public @interface Url {
    /** メッセージ. */
    String message() default "{jp.co.ogis_ri.citk.policytool.common.validation.annotation.Url.message.default}";

    /** グループ. */
    Class<?>[] groups() default {};

    /** 荷重. */
    Class<? extends Payload>[] payload() default {};

    /**
     * ルールの内部リスト.
     */
    @Target({ElementType.FIELD})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
        /** ルールの配列. */
        Url[] value();
    }
}
