/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

import jp.co.ogis_ri.citk.policytool.common.model.AbstractModel;
import jp.co.ogis_ri.citk.policytool.common.validation.annotation.SubjectCode;
import jp.co.ogis_ri.citk.policytool.common.validation.annotation.SubjectName;

/**
 * サブジェクトを表すクラス.
 */
@Entity
@Table(name = "t_subject")
public class Subject extends AbstractModel<Long> {

    /**
     * デフォルト・シリアル･バージョンID
     */
    private static final long serialVersionUID = 1L;

    /**
     * JPAで永続化するためのサロゲートキー
     */
    @Id
    @GeneratedValue
    private Long id;

    /**
     * サブジェクトコード
     */
    @SubjectCode
    private String subjectCode = null;

    /**
     * サブジェクト名
     */
    @SubjectName
    private String subjectName = null;

    /**
     * ポリシー
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @NotNull
    private Policy policy = null;

    @Override
    public Long getId() {
        return this.id;
    }

    /**
     * このサブジェクトの名前を取得する.
     * 
     * @return サブジェクト名.
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * このサブジェクトの名前を設定する.
     * 
     * @param subjectName サブジェクト名.
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    /**
     * このサブジェクトのサブジェクトコードを取得する.
     * 
     * @return サブジェクトコード.
     */
    public String getSubjectCode() {
        return subjectCode;
    }

    /**
     * このサブジェクトのサブジェクトコードを設定する.
     * 
     * @param subjectCode サブジェクトコード.
     */
    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    /**
     * このサブジェクトを持つポリシーを取得する.
     * 
     * @return ポリシー.
     */
    public Policy getPolicy() {
        return policy;
    }

    /**
     * このサブジェクトを持つポリシーを設定する.
     * 
     * @param policy ポリシー.
     */
    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    /**
     * デフォルト･コンストラクタ
     */
    public Subject() {
    }

    /**
     * コンストラクタ.
     * 
     * @param subjectName サブジェクト名.
     * @param subjectCode サブジェクトコード.
     */
    public Subject(String subjectName, String subjectCode) {
        this.subjectName = subjectName;
        this.subjectCode = subjectCode;
    }
}
