/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.ConstraintValidatorContext.ConstraintViolationBuilder;

import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;

/**
 * ポリシー名,レルム名の組合せが, ポリシードメインで一意であることをチェックする相関項目チェックの, 検証アノテーション.
 * 
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy = {RuleUniquePolicyName.Validator.class})
public @interface RuleUniquePolicyName {
    /** メッセージ. */
    String message() default "{jp.co.ogis_ri.citk.policytool.domain.policy.validation.annotation.RuleUniquePolicyName.message.default}";

    /** グループ. */
    Class<?>[] groups() default {};

    /** 荷重. */
    Class<? extends Payload>[] payload() default {};

    /**
     * ルールの内部リスト.
     */
    @Target({ElementType.TYPE})
    @Retention(RetentionPolicy.RUNTIME)
    @Documented
    @interface List {
        /** ルールの配列. */
        RuleUrlDependOnRealm[] value();
    }

    /**
     * バリデータ.
     */
    class Validator implements
            ConstraintValidator<RuleUniquePolicyName, PolicyValidModel> {
        @Override
        public void initialize(RuleUniquePolicyName arg0) {
        }

        @Override
        public boolean isValid(PolicyValidModel arg0,
                ConstraintValidatorContext arg1) {
            int i = 0;
            // Policy の policyName,realmName の組合せは、ポリシードメインで一意であること。
            for (Policy policy : arg0.getPolicies()) {
                Policy targetPolicy = arg0.getTarget();
                if (targetPolicy.getPolicyName().equals(policy.getPolicyName())
                        && targetPolicy.getRealmName().equals(
                                policy.getRealmName())) {
                    arg1.disableDefaultConstraintViolation();
                    String messageTemplate =
                            arg1.getDefaultConstraintMessageTemplate();
                    ConstraintViolationBuilder builder =
                            arg1.buildConstraintViolationWithTemplate(messageTemplate
                                    + targetPolicy.getRealmName()
                                    + " , "
                                    + targetPolicy.getPolicyName());
                    builder.addNode("policy")
                            .addNode("policyName")
                            .inIterable()
                            .atIndex(i)
                            .addConstraintViolation();

                    return false;
                }
                i++;
            }

            return true;
        }
    }
}
