/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.domain.realm.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

import jp.co.ogis_ri.citk.policytool.common.model.AbstractModel;
import jp.co.ogis_ri.citk.policytool.common.validation.annotation.Url;

/**
 * リファーラルを表すクラス.
 */
@Entity
@Table(name = "t_referral")
public class Referral extends AbstractModel<Long> {
    /**
     * シリアルバージョンID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * JPAで永続化するためのサロゲートキー
     */
    @Id
    @GeneratedValue
    private Long id;

    /**
     * 参照ポリシー
     */
    @Url
    private String refpolicy;

    /**
     * レルム
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @NotNull
    private Realm realm = null;

    @Override
    public Long getId() {
        return this.id;
    }

    /**
     * このリファーラルの参照ポリシーを取得する.
     * 
     * @return このリファーラルの参照ポリシー.
     */
    public String getRefpolicy() {
        return refpolicy;
    }

    /**
     * このリファーラルの参照ポリシーを設定する.
     * 
     * @param refpolicy このリファーラルの参照ポリシー.
     */
    public void setRefpolicy(String refpolicy) {
        this.refpolicy = refpolicy;
    }

    /**
     * このリファーラルを持つレルムを取得する.
     * 
     * @return このリファーラルを持つレルム.
     */
    public Realm getRealm() {
        return realm;
    }

    /**
     * このリファーラルを持つレルムを設定する.
     * 
     * @param realm このリファーラルを持つレルム.
     */
    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    /**
     * コンストラクタ.
     */
    public Referral() {
    }

    /**
     * コンストラクタ.
     * 
     * @param refPolicy 参照ポリシー.
     */
    public Referral(String refPolicy) {
        this.refpolicy = refPolicy;
    }
}
