/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.view.common;

import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;

/**
 * レルムコンボボックスの項目.
 */
public class RealmComboBoxItem {
    /** すべてのレルムを表すレルムコンボボックス項目. */
    public static final RealmComboBoxItem ALL_REALM = new RealmComboBoxItem("",
            null);

    /** レルム名. */
    private String name;

    /** レルムコンボボックス項目の種類. */
    private Type type;

    /** レルムのモデル. */
    private Realm model;

    /**
     * 通常のレルムコンボボックス項目種類の, 新しい RealmComboBoxItem を構築する.
     * 
     * @param name レルム名.
     */
    public RealmComboBoxItem(String name, Realm model) {
        this(name, model, Type.NORMAL);
    }

    /**
     * 項目名と種類を指定して, 新しい RealmComboBoxItem を構築する.
     * 
     * @param name レルム名.
     * @param type レルムコンボボックス項目の種類.
     */
    public RealmComboBoxItem(String name, Realm model, Type type) {
        this.name = name;
        this.model = model;
        this.type = type;
    }

    /**
     * レルム名を取得する.
     * 
     * @return レルム名.
     * 
     */
    public String getRealmName() {
        return this.name;
    }

    /**
     * レルムのモデルを取得する.
     * 
     * @return レルムモデル
     */
    public Realm getRealmModel() {
        return this.model;
    }

    /**
     * レルムコンボボックス項目の種類を取得する.
     * 
     * @return レルムコンボボックス項目の種類.
     * 
     */
    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RealmComboBoxItem) {
            RealmComboBoxItem itemObj = (RealmComboBoxItem) obj;
            return this.name.equals(itemObj.name)
                    && ((this.model == null && itemObj.model == null) || (this.model != null && this.model.equals(itemObj.model)))
                    && this.type.equals(itemObj.type);
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ this.model.hashCode()
                ^ this.type.hashCode();
    }

    /**
     * レルムコンボボックス項目の種類を表す列挙体
     */
    public enum Type {
        /** 通常の Realm 項目 */
        NORMAL,

        /** 全レルムを選択することを表す項目 */
        ALL,
    }
}
