/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import jp.co.ogis_ri.citk.policytool.common.CommonConstants;
import jp.co.ogis_ri.citk.policytool.common.excel.ExcelPolicyWriter;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import jp.co.ogis_ri.citk.policytool.common.resource.MessageInfo;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;
import mockit.Delegate;
import mockit.Expectations;
import mockit.Mocked;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration({ "ExcelPolicyWriterImplTest-context.xml" })
public class ExcelPolicyWriterImplTest {

    /**
     * ポリシーエクスポートクラス
     */
    @Autowired
	@Qualifier("excelPolicyWriterImpl") 
    private ExcelPolicyWriter excelPolicyWriter = null;
    
	@Mocked
	WorkbookWrapper workbookWrapper;
	
	@Test
	public void testWrite() {
		final List<Policy> policyList = new ArrayList<Policy>();
		Policy policy1 = new Policy();
		
		Resource resource11 = new Resource();
		resource11.setResourceURL("url1");
		policy1.getResources().add(resource11);
		Resource resource12 = new Resource();
		resource12.setResourceURL("url2");
		policy1.getResources().add(resource12);
		
		Subject subject11 = new Subject();
		subject11.setSubjectName("g1");
		subject11.setSubjectCode("o=g1,a=12");
		policy1.getSubjects().add(subject11);
		
		policyList.add(policy1);
		
		new Expectations() {
			{
				new WorkbookWrapper((Workbook)any);
				workbookWrapper.selectSheet(CommonConstants.TMPL_SHEET_INDEX, CommonConstants.TMPL_SHEET_ROW_OFFSET, CommonConstants.TMPL_SHEET_COLUMN_OFFSET);
				workbookWrapper.writeRow((List<?>)any);
				workbookWrapper.writeRow((List<?>)any);
				workbookWrapper.writeRow((List<?>)any);
				workbookWrapper.saveAs("testFile", true);
			}
		};
		
		excelPolicyWriter.write("testFile", policyList);
	}
	
	@Test
	public void testWrite_rowZero() {
		final List<Policy> policyList = new ArrayList<Policy>();
		Policy policy1 = new Policy();
		
		policyList.add(policy1);
		
		new Expectations() {
			{
				new WorkbookWrapper((Workbook)any);
				workbookWrapper.selectSheet(CommonConstants.TMPL_SHEET_INDEX, CommonConstants.TMPL_SHEET_ROW_OFFSET, CommonConstants.TMPL_SHEET_COLUMN_OFFSET);
				workbookWrapper.saveAs("testFile", true);
			}
		};
		
		excelPolicyWriter.write("testFile", policyList);
	}
	
	@Test
	public void testWrite_IOException(final HSSFWorkbook workbook, final MessageInfo messageInfo) throws IOException {
		final List<Policy> policyList = new ArrayList<Policy>();
		Policy policy1 = new Policy();
		
		policyList.add(policy1);
		
		new Expectations() {
			{
				new HSSFWorkbook((InputStream)any);
				result = new Delegate() {
					@SuppressWarnings("unused")
					void construct(InputStream is) throws IOException {
						throw new IOException();
					}
				};
			}
		};
		
		try {
			excelPolicyWriter.write("testFile", policyList);
			fail();
		} catch (SystemException e) {
			assertTrue(e.getCause() instanceof IOException);
		}
	}
}
