/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl.model;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import java.util.List;

import org.junit.Test;

public class ExcelPolicyTest {
	@Test
	public void testToValues() {
		ExcelPolicy excelPolicy = new ExcelPolicy();
		
		excelPolicy.setRealmName("realm");
		excelPolicy.setPolicyName("policy");
		excelPolicy.setResourceUrl("url");
		excelPolicy.setGetPermitValue("get");
		excelPolicy.setPostPermitValue("post");
		excelPolicy.setSubject("sbj");
		
		List<String> values = excelPolicy.toValues();
		
		assertThat(values.size(), is(6));
		assertThat(values.get(0), is("realm"));
		assertThat(values.get(1), is("policy"));
		assertThat(values.get(2), is("url"));
		assertThat(values.get(3), is("get"));
		assertThat(values.get(4), is("post"));
		assertThat(values.get(5), is("sbj"));
	}
}
