/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.util.Properties;

import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;

import mockit.Deencapsulation;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import static org.junit.matchers.JUnitMatchers.*;
import static org.hamcrest.CoreMatchers.*;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.fail;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration({"ApplicationContextUtilTest-context.xml"})
public class ApplicationContextUtilTest {
    @Before
    public void before() {
        Deencapsulation.setField(ApplicationContextUtil.class, "context", null);
        Deencapsulation.setField(
                ApplicationContextUtil.class,
                "FILE_APPLICATION_CONTEXT",
                "jp/co/ogis_ri/citk/policytool/common/util/ApplicationContextUtilTest-context.xml");
    }

    @Test
    public void testGetProperties() {
        final String actual = (String)ApplicationContextUtil.getProperties().get("properties");
        assertThat(actual, containsString("hello"));
    }

    @Test
    public void testGetResources() {
        final String actual = (String)ApplicationContextUtil.getResources().getMessage("messages");
        assertThat(actual, containsString("hello"));
    }

    @Test
    public void testGetBean() {
        final Properties actual1 = (Properties)ApplicationContextUtil.getBean("policytoolProperty");
        assertThat(actual1.getProperty("properties"), containsString("hello"));

        final MessageSourceAccessor actual2 = ApplicationContextUtil.getBean(MessageSourceAccessor.class);
        assertThat(actual2.getMessage("messages"), containsString("hello"));
    }

    @Test
    public void testGetBean_SystemException() {
    	try {
    		ApplicationContextUtil.getBean("abc");
    		fail("SystemException がスローされませんでした。");
    	} catch (SystemException e) {
    		assertThat(e.getMessage(), is("Not found spring bean id: " + "abc"));
    	}
    }
    
    @Test
    public void testGetContext() {
        assertThat(ApplicationContextUtil.getContext(), notNullValue());
    }
}
