/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.not;
import static org.junit.Assert.assertThat;

import java.util.Map;

import org.junit.Test;

public class OpenAMNamingUtilTest {
    @Test
    public void testSplitValue() {
        String test1 = "id=group1,ou=group,dc=opensso,dc=java,dc=net";
        
        Map<String, String> resultMap = OpenAMNamingUtil.splitValue(test1);
        assertThat(resultMap.get("id"), is("group1"));
        assertThat(resultMap.get("ou"), is("group"));
        assertThat(resultMap.get("dc"), is("opensso,java,net"));
    }

    @Test
    public void testGenerateRuleName() {
        String result1 = OpenAMNamingUtil.generateRuleName();
        String result2 = OpenAMNamingUtil.generateRuleName();
        
        assertThat(result1.substring(0, 4 + 1), is("rule_"));
        assertThat(result1, not(result2));
        assertThat(result1.length(), is(4 + 1 + 36));
    }

    @Test
    public void testGenerateSubjectName() {
        String result1 = OpenAMNamingUtil.generateSubjectName();
        String result2 = OpenAMNamingUtil.generateSubjectName();
        
        assertThat(result1.substring(0, 7 + 1), is("subject_"));
        assertThat(result1, not(result2));
        assertThat(result1.length(), is(7 + 1 + 36));
    }

    @Test
    public void testGenerateSubjectsName() {
        String result1 = OpenAMNamingUtil.generateSubjectsName();
        String result2 = OpenAMNamingUtil.generateSubjectsName();
        
        assertThat(result1.substring(0, 8 + 1), is("subjects_"));
        assertThat(result1, not(result2));
        assertThat(result1.length(), is(8 + 1 + 36));
    }
}
