/*
 * Copyright (C) 2011-2012 OGIS-RI Co.,Ltd. All rights reserved.
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * 
 */
package jp.co.ogis_ri.citk.policytool.service.policyset.impl;

import static org.junit.Assert.*;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;

import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.PolicyRepository;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.validation.PolicyValidModel;
import jp.co.ogis_ri.citk.policytool.domain.realm.RealmRepository;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import jp.co.ogis_ri.citk.policytool.service.common.validation.PolicyValidModelFactory;

import mockit.Deencapsulation;
import mockit.Expectations;
import mockit.Mocked;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * @author Z1200010
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration({"PolicySetServiceImplTest-context.xml"})
public class PolicySetServiceImplTest {

    @Autowired
    @Qualifier(value = "policySetService")
    private PolicySetServiceImpl service = null;
    
    @Mocked
    private TestPolicyRepository policyRepository;
    
    @Mocked
    private TestValidator validator;
    
    @SuppressWarnings("unused")
	@Mocked
    private PolicyValidModelFactory modelFactory;
    
    @Before
    public void setUp() throws Exception {
        Deencapsulation.setField(ApplicationContextUtil.class, "context", null);
        Deencapsulation.setField(
                ApplicationContextUtil.class,
                "FILE_APPLICATION_CONTEXT",
                "jp/co/ogis_ri/citk/policytool/service/policyset/impl/PolicySetServiceImplTest-context.xml");
    }

    /**
	 * {@link jp.co.ogis_ri.citk.policytool.service.policyset.impl.PolicySetServiceImpl#addPolicy(jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy)} のためのテスト・メソッド。
	 */
	@Test
	public void testAddPolicy() {

		final Policy policy = new Policy("dummy_realm", "dummy_policy");
		final Set<ConstraintViolation<Policy>> valid_ret = new HashSet<ConstraintViolation<Policy>>();
		final PolicyValidModel model = new PolicyValidModel();

		new Expectations () {
			{
				validator.validate(policy); result = valid_ret;
				PolicyValidModelFactory.create(policy); result = model;
				model.setTarget(policy);
				validator.validate(model, PolicyValidModel.Create.class); result = valid_ret;
				policyRepository.persist(policy);
			}
		};

		ConstraintViolation<?> ret = service.addPolicy(policy);
		assertNull(ret);
	}

	/**
	 * {@link jp.co.ogis_ri.citk.policytool.service.policyset.impl.PolicySetServiceImpl#modifyPolicy(jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy)} のためのテスト・メソッド。
	 */
	@Test
	public void testModifyPolicy() {

		final Policy policy = new Policy("dummy_realm", "dummy_policy");
		final Set<ConstraintViolation<Policy>> valid_ret = new HashSet<ConstraintViolation<Policy>>();
		final PolicyValidModel model = new PolicyValidModel();

		new Expectations () {
			{
				validator.validate(policy); result = valid_ret;
				PolicyValidModelFactory.create(policy); result = model;
				model.setTarget(policy);
				validator.validate(model, PolicyValidModel.Update.class); result = valid_ret;
				policyRepository.merge(policy);
			}
		};

		ConstraintViolation<?> ret = service.modifyPolicy(policy);
		assertNull(ret);
	}
	
	public static class TestPolicyValidModelFactory extends PolicyValidModelFactory {
		public static PolicyValidModel create(Policy policy) {
			return null;
		}
	}

	/**
	 * PolicyRepository をモックに置換するためのダミークラス
	 *
	 */
	public static class TestPolicyRepository implements PolicyRepository{

		public TestPolicyRepository() {
		}
		
		@Override
		public Policy findById(Long id) {
			return null;
		}

		@Override
		public List<Policy> findAll() {
			return null;
		}

		@Override
		public void persist(Policy entity) {
		}

		@Override
		public Policy merge(Policy entity) {
			return null;
		}

		@Override
		public void remove(Policy entity) {
		}

		@Override
		public void removeAll() {
		}

		@Override
		public void reflesh(Policy entity) {
		}

		@Override
		public void sync(String realmName) {
		}

		@Override
		public List<Policy> findPoliciesByRealmName(String realmName) {
			return null;
		}

		@Override
		public List<Policy> findPolicies(String realmName, String subjectName,
				String url) {
			return null;
		}

		@Override
		public void importPolicies(List<Policy> policies) {
		}
		
	}
	
	/**
	 * RealmRepository をモックに置換するためのダミークラス
	 *
	 */
	public static class TestRealmRepository implements RealmRepository {

		public TestRealmRepository() {
		}
		
		@Override
		public Realm findById(Long id) {
			return null;
		}

		@Override
		public List<Realm> findAll() {
			return null;
		}

		@Override
		public void persist(Realm entity) {
		}

		@Override
		public Realm merge(Realm entity) {
			return null;
		}

		@Override
		public void remove(Realm entity) {
		}

		@Override
		public void removeAll() {
		}

		@Override
		public void reflesh(Realm entity) {
		}

		@Override
		public void sync() {
		}
		
		@Override
		public List<String> findGroupNames(Realm realm) {
			return null;
		}

		@Override
		public List<Referral> findReferrals(Realm realm) {
			return null;
		}

		@Override
		public Realm findRealmByName(String realmName) {
			return null;
		}

		@Override
		public List<Group> findGroupByRealm(Realm realm) {
			return null;
		}

		@Override
		public Group findGroupByName(Realm realm, String groupName) {
			return null;
		}
		
	}
	
	/**
	 * Validator をモックに置換するためのダミークラス
	 *
	 */
	public static class TestValidator implements Validator {

		@Override
		public <T> Set<ConstraintViolation<T>> validate(T object,
				Class<?>... groups) {
			return null;
		}

		@Override
		public <T> Set<ConstraintViolation<T>> validateProperty(T object,
				String propertyName, Class<?>... groups) {
			return null;
		}

		@Override
		public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType,
				String propertyName, Object value, Class<?>... groups) {
			return null;
		}

		@Override
		public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
			return null;
		}

		@Override
		public <T> T unwrap(Class<T> type) {
			return null;
		}
	}
}
