unit ecma_dynacall;

interface

uses
  Windows,Sysutils,Classes,ecma_type,dynamiccall,hashtable;

type
  //dynacall
  TJDynaCall = class(TJObject)
  private
    FModules: TIntegerHashtable;
    procedure HashtableOnFreeItem(Sender: TObject; P: PHashItem);
  protected
    function DoRegister(Param: TJValueList): TJValue;
  public
    constructor Create(AEngine: TJBaseEngine; Param: TJValueList = nil; RegisteringFactory: Boolean = True); override;
    destructor Destroy; override;
  end;


procedure RegisterDMS(Engine: TJBaseEngine);


implementation

procedure RegisterDMS(Engine: TJBaseEngine);
begin
  Engine.ImportObject('DynaCall',TJDynaCall);
end;


{ TJDynaCall }

constructor TJDynaCall.Create(AEngine: TJBaseEngine;
  Param: TJValueList; RegisteringFactory: Boolean);
begin
  inherited;
  FModules := TIntegerHashtable.Create(13,True);
  FModules.OnFreeItem := HashtableOnFreeItem;

  RegistName('DynaCall');
  RegistMethod('register',DoRegister);
end;

destructor TJDynaCall.Destroy;
begin
  FModules.Clear;
  FreeAndNil(FModules);
  inherited;
end;

function TJDynaCall.DoRegister(Param: TJValueList): TJValue;
//֐o^
var
  f: IJFunction;
  s1,s2,s3,lib,func: String;
  i: Integer;
  v: TJValue;
  module: HModule;
begin
  Result := BuildObject(Self);
  s1 := '';
  s2 := '';
  s3 := '';
  lib := '';
  func := '';

  if IsParam1(Param) then
  begin
    for i := 0 to Param.Count - 1 do
    begin
      v := Param[i];
      case i of
        0: lib := AsString(@v);
        1: func := AsString(@v);
        2: s1 := LowerCase(AsString(@v));
        3: s2 := LowerCase(AsString(@v));
        4: s3 := LowerCase(AsString(@v));
      end;
    end;

    //֐ȂΓo^
    if (func <> '') and (lib <> '') then
    begin
      EmptyFunction(f);
      f.Symbol := func;
      f.FuncType := ftDynaCall;
      f.vDynaCall^ := ParseDynaDeclare([s1,s2,s3]);

      //DLL`FbN
      if FModules.HasKey(lib) then
      begin
        //݂
        module := FModules[lib];
        //֐ǂݍ
        f.vDynaCall.ProcAddr := SearchProcAddress(module,func);
        //sO
        if not Assigned(f.vDynaCall.ProcAddr) then
          raise EJThrow.Create(E_DLL,func);
      end
      else begin
        //DLLǂݍ
        module := LoadLibrary(PChar(lib));
        //sƗO
        if module = 0 then
          raise EJThrow.Create(E_DLL,lib);

        f.vDynaCall.ProcAddr := SearchProcAddress(module,func);
        //sDLLėO
        if not Assigned(f.vDynaCall.ProcAddr) then
        begin
          FreeLibrary(module);
          raise EJThrow.Create(E_DLL,func);
        end
        else //DLLnbVɓ
          FModules[lib] := module
      end;

      inherited SetValue(func,BuildFunction(f),False);
    end
    else //O
      raise EJThrow.Create(E_DLL,'register error: ' + lib + ' ' + func);
  end
  else
    raise EJThrow.Create(E_DLL,'register error: ' + lib + ' ' + func);
end;

procedure TJDynaCall.HashtableOnFreeItem(Sender: TObject; P: PHashItem);
//DLL
begin
  FreeLibrary(P^.vInteger);
end;

end.
