/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;
import jp.sourceforge.projects.ee2e.core.relax.EE2REe2e;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTemplate;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTemplateList;
import jp.sourceforge.projects.ee2e.core.wizards.EE2ENewWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.part.FileEditorInput;

public abstract class EE2EAbstractNewWizard
extends Wizard
implements INewWizard {
    private EE2ENewWizardPage page;
    private ISelection structuredSelection;

    protected EE2ENewWizardPage getPage() {
        return this.page;
    }

    protected void setPage(EE2ENewWizardPage page) {
        this.page = page;
    }

    protected ISelection getISelection() {
        return this.structuredSelection;
    }

    public EE2EAbstractNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public final void addPages() {
        ImageDescriptor image;
        String targetKey = this.getTargetKey();
        int targetIndex = this.getTargetIndex();
        ISelection iSelection = this.getISelection();
        try {
            URL prefix = EE2EPlugin.getDefault().getBundle().getEntry("icons/");
            image = ImageDescriptor.createFromURL((URL)new URL(prefix, String.valueOf(targetKey) + ".gif"));
        }
        catch (MalformedURLException malformedURLException) {
            image = null;
        }
        this.setDefaultPageImageDescriptor(image);
        EE2ENewWizardPage wizardPage = new EE2ENewWizardPage(iSelection, image, targetKey, targetIndex);
        this.setPage(wizardPage);
        this.addPage((IWizardPage)this.getPage());
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        EE2EAbstractNewWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openMyContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage benchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                FileEditorInput input = new FileEditorInput(file);
                try {
                    EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
                    IEditorDescriptor descripter = registry.getDefaultEditor(file.getName());
                    benchPage.openEditor((IEditorInput)input, descripter.getId());
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    public abstract String getTargetKey();

    public abstract int getTargetIndex();

    protected InputStream openMyContentStream() {
        String key = this.getTargetKey();
        int index = this.getTargetIndex();
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e(key);
        if (index < 0 && index < ee2e.getTemplateListCount()) {
            return new ByteArrayInputStream("".getBytes());
        }
        EE2RTemplateList templateList = ee2e.getTemplateList(index);
        if (templateList == null) {
            return new ByteArrayInputStream("".getBytes());
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < templateList.getTemplateCount()) {
            EE2RTemplate template = templateList.getTemplate(i);
            String string = template.getName();
            if (string != null && !string.equals("")) {
                int of;
                StringBuffer sb = new StringBuffer(string);
                while (sb.indexOf("\\n") >= 0) {
                    of = sb.indexOf("\\n");
                    sb.replace(of, of + 2, "\n");
                }
                while (sb.indexOf("\\t") >= 0) {
                    of = sb.indexOf("\\t");
                    sb.replace(of, of + 2, "\t");
                }
                buffer.append(sb);
            } else {
                String type = template.getType();
                IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
                if (type.equals("contry")) {
                    buffer.append(store.getString("contry"));
                } else if (type.equals("language")) {
                    buffer.append(store.getString("language"));
                } else {
                    buffer.append(EE2EPlugin.getResourceString(type));
                }
            }
            ++i;
        }
        String contents = buffer.toString();
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "jp.sourceforge.projects.ee2e.core", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.structuredSelection = selection;
    }
}

