package jp.sourceforge.projects.ee2e.core.dedit;
import java.util.*;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.*;

import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.editors.EE2EToolkit;
import jp.sourceforge.projects.ee2e.core.relax.EE2RDefvar;
import jp.sourceforge.projects.ee2e.core.relax.EE2REe2e;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTag;
import jp.sourceforge.projects.ee2e.core.relax.IEE2RDefvarChoice;
import jp.sourceforge.projects.ee2e.core.ttledit.TtlColorProvider;
import jp.sourceforge.projects.ee2e.core.ttledit.TtlWordDetector;

public class DScanner  extends RuleBasedScanner {
    public static final String TARGET = "d";
    public static final String BEGIN = "d-begin-table";
    public static final String SECTION = "d-section-table";

    /**
     * Detector for empty comments.
     */
    private static class EmptyCommentDetector implements IWordDetector {

        /*
         * @see IWordDetector#isWordStart
         */
        public boolean isWordStart(char c) {
            return (c == '/');
        }

        /*
         * @see IWordDetector#isWordPart
         */
        public boolean isWordPart(char c) {
            return (c == '*' || c == '/');
        }
    }

    /**
     * Word rule for empty comments.
     */
    private static class EmptyCommentRule extends WordRule implements IPredicateRule {

        private IToken fSuccessToken;
        /**
         * Constructor for EmptyCommentRule.
         * @param successToken
         */
        public EmptyCommentRule(IToken successToken) {
            super(new EmptyCommentDetector());
            fSuccessToken= successToken;
            addWord("/**/", fSuccessToken); //$NON-NLS-1$
        }

        /*
         * @see IPredicateRule#evaluate(ICharacterScanner, boolean)
         */
        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return evaluate(scanner);
        }

        /*
         * @see IPredicateRule#getSuccessToken()
         */
        public IToken getSuccessToken() {
            return fSuccessToken;
        }
    }

    /**
	 * Creates a Java code scanner
	 */
	public DScanner(TtlColorProvider provider) {
        super();

        IToken string= new Token(new TextAttribute(provider.getColor(TtlColorProvider.KEYWORD)));
        IToken section= new Token(new TextAttribute(provider.getColor(TtlColorProvider.TYPE)));
        IToken begin= new Token(new TextAttribute(provider.getColor(TtlColorProvider.STRING)));
        IToken comment= new Token(new TextAttribute(provider.getColor(TtlColorProvider.SINGLE_LINE_COMMENT)));
        IToken other= new Token(new TextAttribute(provider.getColor(TtlColorProvider.DEFAULT)));

        List rules= new ArrayList();

        // Add rule for single line comments.
        rules.add(new EndOfLineRule("//", comment)); //$NON-NLS-1$

        // Add rule for strings.
        rules.add(new SingleLineRule("\"", "\"", string, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

        // Add rule for character constants.
        rules.add(new SingleLineRule("'", "'", string, '\\')); //$NON-NLS-2$ //$NON-NLS-1$

        // Add special case word rule.
        EmptyCommentRule eWordRule= new EmptyCommentRule(comment);
        rules.add(eWordRule);

        // Add rules for multi-line comments and javadoc.
        rules.add(new MultiLineRule("/*", "*/", comment)); //$NON-NLS-1$ //$NON-NLS-2$

        // Add word rule for keywords, types, and constants.
        WordRule wordRule= new WordRule(new TtlWordDetector(), other);
        this.getDefvarData(wordRule,BEGIN,begin);
        this.getDefvarData(wordRule,SECTION,section);
        rules.add(wordRule);

        IRule[] result= new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
	}
    protected void getDefvarData(WordRule wordRule,String string,IToken token) {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e(TARGET);
        if (ee2e == null) {
            EE2EDebug.printf(1, "getDefvarData/ee2e is null");
            return;
        }
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar(string);
        if(defvar == null) {
            EE2EDebug.printf(1, "getDefvarData/defvar is null");
            return;
        }
        for(int i = 0 ; i < defvar.getContentCount() ; i++) {
            IEE2RDefvarChoice choice = defvar.getContent(i);
            if(! (choice instanceof EE2RTag) ) {
                continue;
            }
            EE2RTag tag = (EE2RTag) choice;
            wordRule.addWord(tag.getName(),token);
        }
    }
}
