package jp.sourceforge.projects.ee2e.core.editors;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.jface.text.BadLocationException;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public abstract class EE2ECompleteMark implements EE2EMenuBehavior {
	public EE2ECompleteMark() {
        /*EMPTY*/
    }
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor, IDocument, ITextSelection)
     */
	public void doBehavior(AbstractTextEditor editor,ITextSelection textSelection) throws BadLocationException {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
		String data = this.getCompleteString();
		document.replace(textSelection.getOffset(), 0, data);
		EE2ESelect sec = new EE2ESelect(textSelection, data.length());
		editor.getSelectionProvider().setSelection(sec);
	}
    /**
     * The character to complement
     */
	protected abstract String getCompleteString();
}
