#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QTextCodec>
#include <QFile>
#include <QSettings>
#include <QDialog>


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
    QTextCodec::setCodecForLocale(QTextCodec::codecForName("UTF-8"));
    QTextCodec::setCodecForTr(QTextCodec::codecForName("UTF-8"));

    init = false;

    ui->setupUi(this);
    Init();

    Search(0);
    init = true;
}

MainWindow::~MainWindow()
{
    QSettings settings("settings.ini", QSettings::IniFormat);
    settings.setIniCodec(QTextCodec::codecForName("UTF-8"));
    settings.setValue("chkWinStateChecked", ui->chkWinState->isChecked());
    settings.setValue("geometry", geometry());
    settings.setValue("chkOnTopChecked", ui->chkOnTop->isChecked());
    settings.setValue("chkRemFontChecked", ui->chkRemFont->isChecked());
    settings.setValue("remFont", ui->fontList->currentFont().family());
    settings.setValue("fontSizeValue", ui->spinFontSize->value());

    delete ui;
}

void MainWindow::Init()
{
    ui->optTab->setTabText(0, tr("アクション"));
    ui->optTab->setTabText(1, tr("フォント"));
    ui->optTab->setTabText(2, tr("ウィンドウ"));

    QSettings settings("settings.ini", QSettings::IniFormat);
    settings.setIniCodec(QTextCodec::codecForName("UTF-8"));

    ui->chkWinState->setChecked(settings.value("chkWinStateChecked", true).toBool());
    if (ui->chkWinState->isChecked())
    {
        this->setGeometry(settings.value("geometry", QRect(100, 100, 300, 410)).toRect());
    }

    ui->chkOnTop->setChecked(settings.value("chkOnTopChecked", true).toBool());
    if (ui->chkOnTop->isChecked())
    {
        this->setWindowFlags(Qt::WindowStaysOnTopHint);
    }

    ui->chkRemFont->setChecked(settings.value("chkRemFontChecked", true).toBool());
    if (ui->chkRemFont->isChecked())
    {
        font.setFamily(settings.value("remFont", "Arial").toString());
        ui->fontList->setCurrentFont(font);
        ui->spinFontSize->setValue(settings.value("fontSizeValue", 15).toInt());
    }
}

void MainWindow::Search(int index)
{
    QFile file;
    file.setFileName("list.txt");
    file.open(QIODevice::ReadWrite);
    QTextStream stream(&file);
    stream.setCodec("UTF-8");

    QString line;
    int cnt = 0;
    while (!stream.atEnd()) {
        line = stream.readLine();
        if (line.indexOf("#C") != -1)
        {
            line = line.right(line.length()-3);
            if (init == false)
            {
                ui->cateList->addItem(line);
            }
        }
        else if (line.indexOf("#E") != -1)
        {
            ++cnt;
        }
        else if (cnt == index && line != "" && line.indexOf("#C") == -1)
        {
            ui->picList->addItem(line);
        }
    }

    file.close();
}

void MainWindow::on_picList_clicked(const QModelIndex &index)
{
    ui->copyBox->setText(ui->picList->item(index.row())->text());
    RadioBtnManage();
}

void MainWindow::on_picList_doubleClicked()
{
    clipboard->setText(ui->copyBox->text());
}

void MainWindow::on_cateList_currentIndexChanged(int index)
{
    ui->picList->clear();
    if (init == true)
    {
        Search(index);
    }
}

QString MainWindow::RadioBtnRManage()
{
    if (ui->groupR->isChecked())
    {
        if (ui->radRHand->isChecked())
        {
            return ui->radRHand->text();
        }
        else if (ui->radRShake->isChecked())
        {
            return ui->radRShake->text();
        }
        else if (ui->radRSurp->isChecked())
        {
            return ui->radRSurp->text();
        }
        else if (ui->radRGood->isChecked())
        {
            return ui->radRGood->text();
        }
        else if (ui->radRVGood->isChecked())
        {
            return ui->radRVGood->text();
        }
        else
        {
            return "";
        }
    }
    else
    {
        return "";
    }
}

QString MainWindow::RadioBtnLManage()
{
    if (ui->groupL->isChecked())
    {
        if (ui->radLHand->isChecked())
        {
            return ui->radLHand->text();
        }
        else if (ui->radLShake->isChecked())
        {
            return ui->radLShake->text();
        }
        else
        {
            return "";
        }
    }
    else
    {
        return "";
    }
}

void MainWindow::RadioBtnManage()
{
    if (ui->picList->currentRow() != -1)
    {
        ui->copyBox->setText(RadioBtnRManage() + ui->picList->currentItem()->text() + RadioBtnLManage());
        ui->copyBox->selectAll();
    }
}

void MainWindow::on_fontList_currentFontChanged(const QFont &f)
{
    font = f;
    font.setPointSize(ui->spinFontSize->value());
    ui->picList->setFont(font);
    ui->copyBox->setFont(font);
}

void MainWindow::on_spinFontSize_valueChanged(int arg1)
{
    font = ui->fontList->currentFont();
    font.setPointSize(arg1);
    ui->fontList->setCurrentFont(font);
    ui->copyBox->setFont(font);
}

void MainWindow::on_radRHand_toggled()
{
    RadioBtnManage();
}

void MainWindow::on_radRShake_toggled()
{
    RadioBtnManage();
}

void MainWindow::on_radRSurp_toggled()
{
    RadioBtnManage();
}

void MainWindow::on_radRGood_toggled()
{
    RadioBtnManage();
}

void MainWindow::on_radRVGood_toggled()
{
    RadioBtnManage();
}

void MainWindow::on_radLHand_toggled()
{
    RadioBtnManage();
}

void MainWindow::on_radLShake_toggled()
{
    RadioBtnManage();
}

void MainWindow::on_groupR_toggled()
{
    RadioBtnManage();
}

void MainWindow::on_groupL_toggled()
{
    RadioBtnManage();
}
