/*
 * Decompiled with CFR 0.152.
 */
package feat2;

import feat2.config.FeatConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;

public class Util {
    public static final Locale NULL_LOCALE = new Locale("");
    private static final int MODE_INIT = 0;
    private static final int MODE_READ = 1;
    private static final int MODE_FUNCTION_PARAM = 2;

    public static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static List expandLocale(Locale locale) {
        ArrayList<Locale> list = new ArrayList<Locale>(3);
        if (locale != null && !locale.equals(NULL_LOCALE)) {
            String v = locale.getVariant();
            String c = locale.getCountry();
            String l = locale.getLanguage();
            if (v.length() > 0) {
                list.add(new Locale(l, c, v));
            }
            if (c.length() > 0) {
                list.add(new Locale(l, c));
            }
            if (l.length() > 0) {
                list.add(new Locale(l));
            }
        }
        return list;
    }

    public static Locale parseLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return null;
        }
        String[] elem = StringUtils.split((String)localeString, (char)'_');
        Locale ret = null;
        if (elem.length == 1) {
            ret = new Locale(elem[0]);
        } else if (elem.length == 2) {
            ret = new Locale(elem[0], elem[1]);
        } else if (elem.length == 3) {
            ret = new Locale(elem[0], elem[1], elem[2]);
        }
        return ret;
    }

    public static String[] parseList(String list) {
        String val;
        int len = list.length();
        int mode = 0;
        StringBuffer buf = new StringBuffer(16);
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < len) {
            char ch = list.charAt(i++);
            switch (mode) {
                case 0: {
                    if (Character.isWhitespace(ch)) break;
                    mode = 1;
                    buf.append(ch);
                    break;
                }
                case 1: {
                    if (ch == ',') {
                        String val2 = buf.toString().trim();
                        if (val2 != null && val2.length() > 0) {
                            ret.add(val2);
                        }
                        buf.setLength(0);
                        mode = 0;
                        break;
                    }
                    if (ch == '(') {
                        mode = 2;
                    }
                    buf.append(ch);
                    break;
                }
                case 2: {
                    if (ch == ')') {
                        mode = 1;
                    }
                    buf.append(ch);
                }
            }
        }
        if (buf.length() > 0 && (val = buf.toString().trim()) != null && val.length() > 0) {
            ret.add(val);
        }
        return ret.toArray(new String[ret.size()]);
    }

    static FeatConfig getFeatConfig(ServletContext sctx) {
        FeatConfig conf = (FeatConfig)sctx.getAttribute("feat.config.KEY");
        return conf;
    }

    static void setFeatConfig(ServletContext sctx, FeatConfig config) {
        sctx.setAttribute("feat.config.KEY", (Object)config);
        sctx.setAttribute("feat.config.lastupdate.KEY", (Object)new Long(System.currentTimeMillis()));
    }

    static long getConfigLastUpdateTime(ServletContext sctx) {
        return (Long)sctx.getAttribute("feat.config.lastupdate.KEY");
    }
}

