/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.ObjectUtil;
import feat2.ResourceManager;
import feat2.config.Config;
import feat2.config.ConfigError;
import feat2.config.FeatureConfig;
import feat2.config.type.JavaIdentifier;
import java.util.Iterator;
import java.util.List;

public class ConfigUtil {
    public static boolean validate(Iterator configIterator, FeatErrors errs) {
        boolean ret = true;
        while (configIterator.hasNext()) {
            Config conf = (Config)configIterator.next();
            ret = ret && conf.validate(errs);
        }
        return ret;
    }

    public static boolean validate(Config[] configArray, FeatErrors errs) {
        boolean ret = true;
        for (int i = 0; i < configArray.length; ++i) {
            ret = ret && configArray[i].validate(errs);
        }
        return ret;
    }

    public static Class validateClassLoading(JavaIdentifier className, String attrName, Config config, FeatErrors errs) {
        FeatureConfig featureConf = config.getFeatureConfig();
        if (featureConf == null) {
            return null;
        }
        Class ret = null;
        if (className == null) {
            errs.add(new ConfigError(null, attrName, "null", 10, config));
        } else {
            try {
                ret = ObjectUtil.loadClass(className.getValue(), featureConf.getPackageName().getValue());
            }
            catch (ClassNotFoundException ex) {
                errs.add(new ConfigError(className.getValue(), attrName, "ClassNotFoundException", 10, config));
                ret = null;
            }
        }
        return ret;
    }

    public static Class validateClass(JavaIdentifier className, String attrName, Config config, FeatErrors errs) {
        FeatureConfig featureConf = config.getFeatureConfig();
        if (featureConf == null) {
            return null;
        }
        Class ret = ConfigUtil.validateClassLoading(className, attrName, config, errs);
        if (ret == null) {
            return null;
        }
        try {
            ret.newInstance();
        }
        catch (InstantiationException ex) {
            errs.add(new ConfigError(className.getValue(), attrName, "InstantiationException", 10, config));
            ret = null;
        }
        catch (IllegalAccessException ex) {
            errs.add(new ConfigError(className.getValue(), attrName, "IllegalAccessException", 10, config));
            ret = null;
        }
        return ret;
    }

    public static boolean validateRequired(Object value, String attrName, Config config, FeatErrors errs) {
        if (value == null) {
            errs.add(new ConfigError(null, attrName, "null", 10, config));
            return false;
        }
        return true;
    }

    public static boolean validateResource(String resourceId, Config config, ResourceManager rm, FeatErrors errs) {
        if (rm.getStringResource(resourceId) == null) {
            errs.add(new ConfigError(resourceId, "", "resource", 10, config));
            return false;
        }
        return true;
    }

    public static Config getConfig(List list, String name) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Config conf = (Config)iter.next();
            if (!name.equals(conf.getName().getValue())) continue;
            return conf;
        }
        return null;
    }
}

