/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.config.CommandConfig;
import feat2.config.Config;
import feat2.config.ConfigUtil;
import feat2.config.ExceptionConfig;
import feat2.config.InterceptConfig;
import feat2.config.Resources;
import feat2.config.ResponseConfigBase;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class FeatureRootConfig
extends Config {
    private Identifier name;
    private Boolean createSession;
    private String encoding;
    private JavaIdentifier packageName;
    private HashMap commands = new HashMap();
    private HashMap responses = new HashMap();
    private ArrayList exceptions = new ArrayList();
    private ArrayList intercepts = new ArrayList();
    private Resources resources = new Resources();

    public Boolean getCreateSession() {
        return this.createSession;
    }

    public void setCreateSession(Boolean createSesssion) {
        this.createSession = createSesssion;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public JavaIdentifier getPackageName() {
        return this.packageName;
    }

    public void setPackageName(JavaIdentifier packageName) {
        this.packageName = packageName;
    }

    public void addCommand(CommandConfig command) {
        this.commands.put(command.getName().getValue(), command);
        command.setParent(this);
    }

    public CommandConfig getCommandConfig(String commandName) {
        CommandConfig conf = (CommandConfig)this.commands.get(commandName);
        return conf;
    }

    public void addResponse(ResponseConfigBase response) {
        this.responses.put(response.getName().getValue(), response);
        response.setParent(this);
    }

    public ResponseConfigBase getResponseConfig(String name) {
        return (ResponseConfigBase)this.responses.get(name);
    }

    public void addException(ExceptionConfig exception) {
        this.exceptions.add(exception);
        exception.setParent(this);
    }

    public ExceptionConfig getException(Class exclass) {
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            ExceptionConfig exc = (ExceptionConfig)it.next();
            if (!exc.getCatchClass().isAssignableFrom(exclass)) continue;
            return exc;
        }
        return null;
    }

    public void addIntercept(InterceptConfig intercept) {
        this.intercepts.add(intercept);
        intercept.setParent(this);
    }

    public InterceptConfig[] getInterceptConfigs() {
        return this.intercepts.toArray(new InterceptConfig[0]);
    }

    public void addResources(Resources resources) {
        this.resources.addResources(resources);
    }

    public String getStringResource(String resourceName, Locale locale) {
        return this.resources.getString(resourceName, locale);
    }

    public Resources getResources() {
        return this.resources;
    }

    public String getElementName() {
        return "feature";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;
        ret = ret && ConfigUtil.validateRequired(this.name, "name", this, errs);
        ret = ret && ConfigUtil.validate(this.commands.values().iterator(), errs);
        ret = ret && ConfigUtil.validate(this.responses.values().iterator(), errs);
        ret = ret && ConfigUtil.validate(this.exceptions.iterator(), errs);
        ret = ret && ConfigUtil.validate(this.intercepts.iterator(), errs);
        return ret;
    }
}

