/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.config.CommandConfig;
import feat2.config.Config;
import feat2.config.ConfigError;
import feat2.config.ConfigUtil;
import feat2.config.type.Identifier;
import feat2.config.type.IdentifierList;
import feat2.config.type.Scope;
import java.util.ArrayList;

public class OutputConfig
extends Config {
    private Identifier name;
    private Identifier response;
    private ArrayList outputObjects = new ArrayList();
    private Scope scope;

    public Identifier getResponse() {
        return this.response;
    }

    public void setResponse(Identifier response) {
        this.response = response;
    }

    public void setOutputObjects(IdentifierList nameList) {
        for (int i = 0; i < nameList.size(); ++i) {
            String name = nameList.get(i).getValue();
            Mapping mp = new Mapping(name, name, null);
            this.outputObjects.add(mp);
        }
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void addOutputMapping(String localName, String outputName, String scope) {
        Scope scopeObj = null;
        if (scope != null) {
            scopeObj = new Scope(scope);
        }
        Mapping o = new Mapping(localName, outputName, scopeObj);
        this.outputObjects.add(o);
    }

    public Mapping[] getOutputMapping() {
        return this.outputObjects.toArray(new Mapping[0]);
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public String getElementName() {
        return "output";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;
        ret = ret && ConfigUtil.validateRequired(this.name, "name", this, errs);
        ret = ret && ConfigUtil.validateRequired(this.response, "response", this, errs);
        String responseName = this.response.getValue();
        if (responseName != null && this.getFeatureConfig().getResponseConfig(responseName) == null) {
            errs.add(new ConfigError(responseName, "response", "referrence.response", 10, this));
        }
        CommandConfig commandConf = (CommandConfig)this.getParent();
        for (int i = 0; i < this.outputObjects.size(); ++i) {
            Mapping m = (Mapping)this.outputObjects.get(i);
            if (ConfigUtil.validateRequired(m.getLocalName(), "local-name", this, errs) && ConfigUtil.validateRequired(m.getOutputName(), "output-name", this, errs)) {
                if (!Identifier.isIdentifier(m.localName)) {
                    errs.add(new ConfigError(m.localName, "local-name", "value_format", 10, this));
                }
                if (!Identifier.isIdentifier(m.outputName)) {
                    errs.add(new ConfigError(m.outputName, "output-name", "value_format", 10, this));
                }
                if (commandConf.getActionComponentConfig(m.getLocalName()) == null) {
                    errs.add(new ConfigError(m.getLocalName(), "local-name", "referrence", 10, this));
                }
            } else {
                ret = false;
            }
            if (m.scope != null) continue;
            m.scope = this.scope;
        }
        return ret;
    }

    public class Mapping {
        String localName;
        String outputName;
        Scope scope;

        private Mapping(String localName, String outputName, Scope scope) {
            this.localName = localName;
            this.outputName = outputName;
            this.scope = scope;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getOutputName() {
            return this.outputName;
        }

        public Scope getScope() {
            return this.scope;
        }
    }
}

