/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.config.FileLocator;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletContext;

public class ServletFileLocator
implements FileLocator {
    private ServletFileLocator root;
    private ServletContext ctx;
    private URI path;

    public ServletFileLocator(String path, ServletContext ctx) throws URISyntaxException, IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("path:null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("ctx:null");
        }
        this.ctx = ctx;
        this.path = new URI(path);
        this.root = this;
    }

    private ServletFileLocator(URI path, ServletContext ctx, ServletFileLocator root) {
        this.ctx = ctx;
        this.path = path;
        this.root = root;
    }

    public InputStream openInputStream() throws IOException {
        return this.ctx.getResourceAsStream(this.path.getPath());
    }

    public String getURL() throws MalformedURLException {
        URL url = this.getURL_();
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }

    private URL getURL_() throws MalformedURLException {
        return this.ctx.getResource(this.path.getPath());
    }

    public String getURIString() {
        try {
            return this.getURL();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean exists() {
        try {
            return this.getURL_() != null;
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public String getFilename() {
        String pathstr = this.path.getPath();
        if (pathstr.endsWith("/")) {
            return null;
        }
        int slashIndex = pathstr.lastIndexOf(47);
        if (slashIndex == -1) {
            return pathstr;
        }
        return pathstr.substring(slashIndex + 1);
    }

    public long getLastModified() throws IOException {
        URL url = this.getURL_();
        if (url == null) {
            return 0L;
        }
        URLConnection con = url.openConnection();
        con.connect();
        return con.getLastModified();
    }

    public FileLocator newLocation(String relativePath) throws IllegalArgumentException {
        if (relativePath != null) {
            if (relativePath.startsWith("/")) {
                throw new IllegalArgumentException("\"" + relativePath + "\" '/'\u3067\u59cb\u307e\u308b\u30d1\u30b9\u306f\u6307\u5b9a\u3067\u304d\u306a\u3044");
            }
            if (relativePath.startsWith(".")) {
                throw new IllegalArgumentException("\"" + relativePath + "\" \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u306e\u5148\u982d\u306b'.'\u306f\u4f7f\u7528\u3067\u304d\u306a\u3044");
            }
            if (relativePath.indexOf("..") > -1) {
                throw new IllegalArgumentException("\"" + relativePath + "\" \u4e0a\u4f4d\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u6307\u5b9a\u3067\u304d\u306a\u3044");
            }
            URI newUri = this.path.resolve(relativePath);
            return new ServletFileLocator(newUri, this.ctx, this.root);
        }
        return this;
    }

    public FileLocator rootLocation() {
        return this.root;
    }

    public String toString() {
        return this.path.getPath();
    }

    public boolean equals(Object o) {
        ServletFileLocator loc = (ServletFileLocator)o;
        boolean ret = this.path.getPath().equals(loc.path.getPath());
        if (this.root != this) {
            ret = ret && this.root.equals(loc.root);
        }
        return ret;
    }
}

