/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.config.FileLocator;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class URLFileLocator
implements FileLocator {
    private URL path;
    private URLFileLocator root;

    public URLFileLocator(URL path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("path:" + path);
        }
        this.path = path;
        this.root = this;
    }

    URLFileLocator(URL path, URLFileLocator root) {
        this.path = path;
        this.root = root;
    }

    public InputStream openInputStream() throws IOException {
        return this.path.openStream();
    }

    public String getURL() {
        return this.path.toExternalForm();
    }

    public String getURIString() {
        try {
            return new URI(this.path.toExternalForm()).toASCIIString();
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean exists() {
        try {
            URLConnection con = this.path.openConnection();
            con.connect();
            int len = con.getContentLength();
            return len > 0;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public String getFilename() {
        return this.path.getFile();
    }

    public long getLastModified() throws IOException {
        long ret = -1L;
        URLConnection con = this.path.openConnection();
        con.connect();
        ret = con.getLastModified();
        return ret;
    }

    public FileLocator newLocation(String relativePath) throws IllegalArgumentException {
        if (relativePath != null) {
            try {
                if (relativePath.startsWith("/")) {
                    throw new IllegalArgumentException("\"" + relativePath + "\" '/'\u3067\u59cb\u307e\u308b\u30d1\u30b9\u306f\u6307\u5b9a\u3067\u304d\u306a\u3044 relativePath:" + relativePath);
                }
                if (relativePath.startsWith(".")) {
                    throw new IllegalArgumentException("\"" + relativePath + "\" \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u306e\u5148\u982d\u306b'.'\u306f\u4f7f\u7528\u3067\u304d\u306a\u3044 relativePath:" + relativePath);
                }
                if (relativePath.indexOf("..") > -1) {
                    throw new IllegalArgumentException("\"" + relativePath + "\" \u4e0a\u4f4d\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u6307\u5b9a\u3067\u304d\u306a\u3044 relativePath:" + relativePath);
                }
                URI current = new URI(this.path.toExternalForm());
                URI newUri = current.resolve(relativePath);
                return new URLFileLocator(newUri.toURL(), this.root);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
        } else {
            return this;
        }
        return null;
    }

    public FileLocator rootLocation() {
        return this.root;
    }

    public String toString() {
        return this.path.toExternalForm();
    }

    public boolean equals(Object o) {
        URLFileLocator loc = (URLFileLocator)o;
        boolean ret = this.path.equals(loc.path);
        if (this.root != this) {
            ret = ret && this.root.equals(loc.root);
        }
        return ret;
    }
}

