/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.View;
import feat2.config.Config;
import feat2.config.ConfigError;
import feat2.config.ConfigUtil;
import feat2.config.ConfigurationException;
import feat2.config.DIComponentConfig;
import feat2.config.InputConfigBase;
import feat2.config.InputSupport;
import feat2.config.ValidatableComponentConfig;
import feat2.config.ValidationConfig;
import feat2.config.ValidationSupport;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

public class ViewConfig
extends Config
implements DIComponentConfig,
ValidatableComponentConfig {
    private JavaIdentifier className;
    private InputSupport inputs = new InputSupport(this);
    private ValidationSupport validations = new ValidationSupport(this);
    private Identifier errorResponse;
    private Class viewClass;

    public Identifier getName() {
        return null;
    }

    public JavaIdentifier getClassName() {
        return this.className;
    }

    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public Identifier getErrorResponse() {
        return this.errorResponse;
    }

    public void setErrorResponse(Identifier errorResponse) {
        this.errorResponse = errorResponse;
    }

    public View getViewInstance() {
        try {
            return (View)this.viewClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public void addInput(InputConfigBase input) {
        this.inputs.addInput(input);
    }

    public InputConfigBase[] getInputs() {
        return this.inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return this.inputs.getInputConfig(propertyName);
    }

    public void addValidation(ValidationConfig validation) {
        this.validations.addValidation(validation);
    }

    public ValidationConfig[] getValidations() {
        return this.validations.getValidations();
    }

    public ValidationConfig getValidationConfig(String name) {
        return this.validations.getValidationConfig(name);
    }

    public String getPropertyNameId(String propertyName) {
        return this.getInputConfig(propertyName).getDisplayName();
    }

    public String getElementName() {
        return "view";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;
        this.viewClass = ConfigUtil.validateClass(this.className, "class", this, errs);
        if (this.viewClass == null) {
            ret = false;
        }
        if (this.validations.count() > 0 && this.errorResponse == null) {
            errs.add(new ConfigError(null, "error-response", "error_response", 10, this));
        }
        ret = ret && this.inputs.validate(errs);
        ret = ret && this.validations.validate(errs);
        return ret;
    }
}

