/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import feat2.ApplicationException;
import feat2.CommandContext;
import feat2.FileUploadException;
import feat2.ObjectUtil;
import feat2.PropertyAccessException;
import feat2.Response;
import feat2.TemplateParsingException;
import feat2.config.BeanXMLConfig;
import feat2.config.type.Scope;
import feat2.impl.XMLWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;

public class BeanXMLResponse
implements Response {
    private BeanXMLConfig config;

    public BeanXMLResponse(BeanXMLConfig config) {
        this.config = config;
    }

    public String output(CommandContext ctx) throws IOException, PropertyAccessException, TemplateParsingException, ServletException, ApplicationException, FileUploadException {
        Scope scope = this.config.getScope();
        if (scope == null) {
            scope = new Scope("local");
        }
        Object retVal = ctx.getAttribute(this.config.getRef().getName(), scope);
        XMLWriter w = new XMLWriter();
        this.writeObject("", retVal, w);
        String xml = w.toString();
        HttpServletResponse resp = ctx.getResponse();
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        writer.print(xml);
        return null;
    }

    private void writeObject(String name, Object val, XMLWriter w) {
        if (val == null) {
            return;
        }
        if (val instanceof List) {
            this.writeList(name, (List)val, w);
        } else if (val.getClass().isArray()) {
            this.writeArray(name, (Object[])val, w);
        } else if (val instanceof Map) {
            this.writeMap(name, (Map)val, w);
        } else if (val instanceof Number) {
            w.writeNumber(name, (Number)val);
        } else if (val instanceof Boolean) {
            w.writeBoolean(name, (Boolean)val);
        } else if (val instanceof Character) {
            w.writeString(name, val.toString());
        } else if (val instanceof String) {
            w.writeString(name, val.toString());
        } else if (val instanceof Date) {
            w.writeDate(name, (Date)val);
        } else {
            this.writeBean(name, val, w);
        }
    }

    private void writeList(String name, List list, XMLWriter w) {
        w.startList(name);
        for (int i = 0; i < list.size(); ++i) {
            this.writeObject("", list.get(i), w);
        }
        w.endList();
    }

    private void writeArray(String name, Object[] a, XMLWriter w) {
        w.startList(name);
        for (int i = 0; i < a.length; ++i) {
            this.writeObject("", a[i], w);
        }
        w.endList();
    }

    private void writeMap(String name, Map map, XMLWriter w) {
        w.startObject(name, map.getClass().getName());
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.writeObject(key, map.get(key), w);
        }
        w.endObject();
    }

    private void writeBean(String name, Object bean, XMLWriter w) {
        w.startObject(name, bean.getClass().getName());
        String[] propNames = ObjectUtil.getPropertyNames(bean);
        for (int i = 0; i < propNames.length; ++i) {
            if (propNames[i].equals("class")) continue;
            try {
                Object prop = ObjectUtil.getProperty(bean, propNames[i]);
                this.writeObject(propNames[i], prop, w);
                continue;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
            catch (InvocationTargetException ex) {
                continue;
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        w.endObject();
    }
}

