/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;

public class Cache {
    private HashMap buf = new HashMap();
    private long cleanTime = 0L;

    public synchronized void put(Object key, Object obj, long ttl) {
        CacheEntry entry = new CacheEntry(obj, ttl);
        this.buf.put(key, entry);
    }

    public synchronized Object get(Object key) {
        CacheEntry entry = (CacheEntry)this.buf.get(key);
        if (entry != null) {
            Object ret = entry.get();
            if (ret == null) {
                this.buf.remove(key);
            }
            return ret;
        }
        return null;
    }

    public synchronized void clean(long interval, long limit) {
        if (this.cleanTime + interval < System.currentTimeMillis()) {
            long start = this.cleanTime = System.currentTimeMillis();
            Iterator it = this.buf.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                CacheEntry entry = (CacheEntry)this.buf.get(key);
                if (entry != null) {
                    Object obj = entry.get();
                    if (obj == null) {
                        this.buf.remove(key);
                    }
                    if (start + limit >= System.currentTimeMillis()) continue;
                    break;
                }
                this.buf.remove(key);
            }
        }
    }

    private class CacheEntry {
        private long time;
        private long ttl;
        private SoftReference ref;

        private CacheEntry(Object obj, long ttl) {
            this.ref = new SoftReference<Object>(obj);
            this.ttl = ttl;
            this.time = System.currentTimeMillis();
        }

        private Object get() {
            Object ret = this.ref.get();
            if (ret != null && this.time + this.ttl < System.currentTimeMillis()) {
                ret = null;
            }
            return ret;
        }
    }
}

