/*
 * Decompiled with CFR 0.152.
 */
package feat2.template;

import feat2.template.HTMLNode;
import feat2.template.NodeIterator;
import feat2.template.impl.HTMLCompositeNodeImpl;
import feat2.template.impl.HTMLNodeImpl;
import java.util.NoSuchElementException;

public class NodeTreeIterator
implements NodeIterator {
    private HTMLNodeImpl start;
    private HTMLNodeImpl current;
    private HTMLNodeImpl next;
    private HTMLNodeImpl currentBak;
    private HTMLNodeImpl nextBak;

    public NodeTreeIterator(HTMLNode node) {
        this.nextBak = this.next = (HTMLNodeImpl)node;
        this.start = this.next;
    }

    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        this.current.detach();
        this.current = null;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Object next() {
        return this.nextNode();
    }

    public HTMLNode nextNode() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = null;
        if (this.current instanceof HTMLCompositeNodeImpl) {
            this.next = ((HTMLCompositeNodeImpl)this.current).firstChild;
        }
        if (this.next == null) {
            if (this.current == this.start) {
                return this.current;
            }
            this.next = this.current.next;
        }
        if (this.next == null) {
            HTMLNodeImpl cur_ = this.current;
            while (this.next == null && (cur_ = cur_.parent) != this.start && cur_ != null) {
                this.next = cur_.next;
            }
        }
        return this.current;
    }

    public void mark() {
        this.currentBak = this.current;
        this.nextBak = this.next;
    }

    public void reset() {
        this.current = this.currentBak;
        this.next = this.nextBak;
    }

    public boolean skip(Object o) {
        HTMLNodeImpl c = this.current;
        HTMLNodeImpl n = this.next;
        while (this.hasNext()) {
            if (this.next() != o) continue;
            return true;
        }
        this.current = c;
        this.next = n;
        return false;
    }
}

