/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.form;

import feat2.template.HTMLElement;
import feat2.template.HTMLNodeList;
import feat2.template.NodeSelector;
import feat2.template.NodeTreeIterator;
import feat2.template.form.CheckBox;
import feat2.template.form.FormControl;
import feat2.template.form.ListItem;
import feat2.template.form.RadioButton;
import feat2.template.form.SelectControl;
import feat2.template.form.SimpleControl;
import feat2.template.form.TextArea;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Form {
    private HTMLElement formElement;

    public Form(HTMLElement formElement) {
        this.formElement = formElement;
    }

    public FormControl getControlElement(String name) {
        HTMLElement[] elements;
        String tagName;
        HTMLNodeList result = NodeSelector.selectElementsByAttribute(new NodeTreeIterator(this.formElement), "name", name);
        ArrayList<HTMLElement> list = new ArrayList<HTMLElement>();
        for (int i = 0; i < result.size(); ++i) {
            HTMLElement node = (HTMLElement)result.get(i);
            tagName = node.getTagName();
            if (tagName == null || !tagName.equalsIgnoreCase("input") && !tagName.equalsIgnoreCase("button") && !tagName.equalsIgnoreCase("select") && !tagName.equalsIgnoreCase("textarea")) continue;
            list.add(node);
        }
        FormControl ret = null;
        if (list.size() > 0 && (tagName = (elements = list.toArray(new HTMLElement[list.size()]))[0].getTagName()) != null) {
            if (tagName.equalsIgnoreCase("input")) {
                String type = elements[0].getAttribute("type");
                if (type.equalsIgnoreCase("text")) {
                    ret = new SimpleControl(elements[0], 1);
                } else if (type.equalsIgnoreCase("password")) {
                    ret = new SimpleControl(elements[0], 2);
                } else if (type.equalsIgnoreCase("submit")) {
                    ret = new SimpleControl(elements[0], 4);
                } else if (type.equalsIgnoreCase("reset")) {
                    ret = new SimpleControl(elements[0], 8);
                } else if (type.equalsIgnoreCase("file")) {
                    ret = new SimpleControl(elements[0], 16);
                } else if (type.equalsIgnoreCase("hidden")) {
                    ret = new SimpleControl(elements[0], 32);
                } else if (type.equalsIgnoreCase("image")) {
                    ret = new SimpleControl(elements[0], 64);
                } else if (type.equalsIgnoreCase("button")) {
                    ret = new SimpleControl(elements[0], 128);
                } else if (type.equalsIgnoreCase("radio")) {
                    ret = new RadioButton(elements);
                } else if (type.equalsIgnoreCase("checkbox")) {
                    ret = new CheckBox(elements);
                }
            } else if (tagName.equalsIgnoreCase("button")) {
                ret = new SimpleControl(elements[0], 4096);
            } else if (tagName.equalsIgnoreCase("select")) {
                ret = new SelectControl(elements[0]);
            } else if (tagName.equalsIgnoreCase("textarea")) {
                ret = new TextArea(elements[0]);
            }
        }
        return ret;
    }

    public String getValue(String name) {
        FormControl control = this.getControlElement(name);
        if (control != null) {
            return control.getValue();
        }
        return null;
    }

    public String[] getValues(String name) {
        FormControl control = this.getControlElement(name);
        if (control != null) {
            return control.getValues();
        }
        return null;
    }

    public void setValues(HttpServletRequest request) {
        Map params = request.getParameterMap();
        this.setValues(params);
    }

    public void setValues(Map map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] values = (String[])map.get(key);
            FormControl control = this.getControlElement(key);
            if (control == null) continue;
            control.setValues(values);
        }
    }

    public void setValue(String name, String value) {
        FormControl control = this.getControlElement(name);
        if (control != null) {
            control.setValue(value);
        }
    }

    public void setValue(String name, String[] values) {
        FormControl control = this.getControlElement(name);
        if (control != null) {
            control.setValues(values);
        }
    }

    public ListItem[] getOptions(String name) {
        FormControl c = this.getControlElement(name);
        if (c != null && c instanceof SelectControl) {
            SelectControl select = (SelectControl)c;
            return select.getItems();
        }
        return null;
    }

    public void setOptions(String name, ListItem[] options) {
        FormControl c = this.getControlElement(name);
        if (c != null && c instanceof SelectControl) {
            SelectControl select = (SelectControl)c;
            select.setItems(options);
        }
    }

    public void addOption(String name, ListItem option) {
        FormControl c = this.getControlElement(name);
        if (c != null && c instanceof SelectControl) {
            SelectControl select = (SelectControl)c;
            select.addItem(option);
        }
    }

    public void setLabel(String name, String label) {
        FormControl control = this.getControlElement(name);
        if (control != null) {
            if ((control.getType() & 0x8C) != 0) {
                control.setValue(label);
                return;
            }
            HTMLElement element = control.getElement();
            if (element != null) {
                this.setLabel(element, label);
            }
        }
    }

    public void setLabels(String name, String[] labels) {
        FormControl control = this.getControlElement(name);
        if (control != null) {
            HTMLElement[] elements = null;
            if (control instanceof CheckBox) {
                elements = ((CheckBox)control).getElements();
            } else if (control instanceof RadioButton) {
                elements = ((RadioButton)control).getElements();
            }
            if (elements != null) {
                int size = elements.length;
                if (size > labels.length) {
                    size = labels.length;
                }
                for (int i = 0; i < size; ++i) {
                    this.setLabel(elements[i], labels[i]);
                }
            }
        }
    }

    private void setLabel(HTMLElement element, String label) {
        HTMLElement labelElement;
        String id = element.getId();
        if (id != null && (labelElement = NodeSelector.getElementByAttribute(new NodeTreeIterator(this.formElement), "for", id)) != null) {
            labelElement.setText(label);
            return;
        }
    }
}

