/*
 * Decompiled with CFR 0.152.
 */
package feat2.validation;

import feat2.CommandContext;
import feat2.StringUtil;
import feat2.validation.ObjectValidator;
import java.util.HashMap;
import java.util.Map;

public class FileTypeValidator
implements ObjectValidator {
    private String[] acceptTypes;

    public boolean validate(Object value) {
        if (value == null) {
            return true;
        }
        if (this.acceptTypes == null || this.acceptTypes.length == 0) {
            return false;
        }
        if (value instanceof CommandContext.MultipartFormItem) {
            CommandContext.MultipartFormItem item = (CommandContext.MultipartFormItem)value;
            String fileName = item.getFileName().toUpperCase();
            for (int i = 0; i < this.acceptTypes.length; ++i) {
                String ext = "." + this.acceptTypes[i];
                if (!fileName.endsWith(ext)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDefaultMessageId() {
        if (this.acceptTypes.length == 1) {
            return "error.validation.filetype";
        }
        return "error.validation.filetypes";
    }

    public Map getKeyrowds() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("types", StringUtil.join(this.acceptTypes, ", "));
        return ret;
    }

    public void setAcceptTypes(String types) {
        this.acceptTypes = StringUtil.split(types.toUpperCase(), " ");
    }
}

