/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrDocument
implements Serializable,
Iterable<Map.Entry<String, Object>> {
    private Map<String, Object> _fields = new HashMap<String, Object>();

    public Collection<String> getFieldNames() {
        return this._fields.keySet();
    }

    public void clear() {
        this._fields.clear();
    }

    public boolean removeFields(String name) {
        return this._fields.remove(name) != null;
    }

    public void setField(String name, Object value) {
        if (value instanceof Object[]) {
            value = new ArrayList<Object>(Arrays.asList((Object[])value));
        } else if (!(value instanceof Collection) && value instanceof Iterable) {
            ArrayList lst = new ArrayList();
            for (Object o : (Iterable)value) {
                lst.add(o);
            }
            value = lst;
        }
        this._fields.put(name, value);
    }

    public void addField(String name, Object value) {
        Object existing = this._fields.get(name);
        if (existing == null) {
            this.setField(name, value);
            return;
        }
        ArrayList<Object> vals = null;
        if (existing instanceof Collection) {
            vals = (ArrayList<Object>)existing;
        } else {
            vals = new ArrayList<Object>(3);
            vals.add(existing);
        }
        if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                vals.add(o);
            }
        } else if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                vals.add(o);
            }
        } else {
            vals.add(value);
        }
        this._fields.put(name, vals);
    }

    public Object getFirstValue(String name) {
        Object v = this._fields.get(name);
        if (v == null || !(v instanceof Collection)) {
            return v;
        }
        Collection c = (Collection)v;
        if (c.size() > 0) {
            return c.iterator().next();
        }
        return null;
    }

    public Object getFieldValue(String name) {
        return this._fields.get(name);
    }

    public Collection<Object> getFieldValues(String name) {
        Object v = this._fields.get(name);
        if (v instanceof Collection) {
            return (Collection)v;
        }
        if (v != null) {
            ArrayList<Object> arr = new ArrayList<Object>(1);
            arr.add(v);
            return arr;
        }
        return null;
    }

    public String toString() {
        return "SolrDocument[" + this._fields.toString() + "]";
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this._fields.entrySet().iterator();
    }

    public Map<String, Collection<Object>> getFieldValuesMap() {
        return new Map<String, Collection<Object>>(){

            @Override
            public Collection<Object> get(Object key) {
                return SolrDocument.this.getFieldValues((String)key);
            }

            @Override
            public boolean containsKey(Object key) {
                return SolrDocument.this._fields.containsKey(key);
            }

            @Override
            public Set<String> keySet() {
                return SolrDocument.this._fields.keySet();
            }

            @Override
            public int size() {
                return SolrDocument.this._fields.size();
            }

            @Override
            public boolean isEmpty() {
                return SolrDocument.this._fields.isEmpty();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsValue(Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<Map.Entry<String, Collection<Object>>> entrySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends Collection<Object>> t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Collection<Object>> values() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> put(String key, Collection<Object> value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> remove(Object key) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Map<String, Object> getFieldValueMap() {
        return new Map<String, Object>(){

            @Override
            public Object get(Object key) {
                return SolrDocument.this.getFirstValue((String)key);
            }

            @Override
            public boolean containsKey(Object key) {
                return SolrDocument.this._fields.containsKey(key);
            }

            @Override
            public Set<String> keySet() {
                return SolrDocument.this._fields.keySet();
            }

            @Override
            public int size() {
                return SolrDocument.this._fields.size();
            }

            @Override
            public boolean isEmpty() {
                return SolrDocument.this._fields.isEmpty();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsValue(Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends Object> t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> values() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> put(String key, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> remove(Object key) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

