/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.robot.dbflute.jdbc.DataSourceHandler;

public class HandlingDataSourceWrapper
implements DataSource {
    private final DataSource _dataSource;
    private final DataSourceHandler _dataSourceHandler;

    public HandlingDataSourceWrapper(DataSource dataSource, DataSourceHandler dataSourceHandler) {
        if (dataSource == null) {
            String msg = "The argument 'dataSource' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        if (dataSourceHandler == null) {
            String msg = "The argument 'dataSourceHandler' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this._dataSource = dataSource;
        this._dataSourceHandler = dataSourceHandler;
    }

    public Connection getConnection() throws SQLException {
        return this._dataSourceHandler.getConnection(this._dataSource);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this._dataSource.getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this._dataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this._dataSource.setLoginTimeout(seconds);
    }
}

