/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.FieldFacet;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardFacetCount;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.OpenBitSet;

class DistribFieldFacet
extends FieldFacet {
    SchemaField sf;
    long missingMaxPossible;
    long[] missingMax;
    OpenBitSet[] counted;
    HashMap<String, ShardFacetCount> counts = new HashMap(128);
    int termNum;
    String queryPrefix;
    int initialLimit;
    boolean needRefinements;
    ShardFacetCount[] countSorted;

    DistribFieldFacet(ResponseBuilder rb, String field) {
        this.sf = rb.req.getSchema().getField(field);
        this.missingMax = new long[rb.shards.length];
        this.counted = new OpenBitSet[rb.shards.length];
        this.queryPrefix = "{!field f=" + field + '}';
    }

    void add(int shardNum, NamedList shardCounts, int numRequested) {
        int sz;
        int numReceived = sz = shardCounts.size();
        OpenBitSet terms = new OpenBitSet(this.termNum + sz);
        long last = 0L;
        for (int i = 0; i < sz; ++i) {
            String name = shardCounts.getName(i);
            long count = ((Number)shardCounts.getVal(i)).longValue();
            if (name == null) {
                this.missingCount += count;
                --numReceived;
                continue;
            }
            ShardFacetCount sfc = this.counts.get(name);
            if (sfc == null) {
                sfc = new ShardFacetCount();
                sfc.name = name;
                ++this.termNum;
                sfc.termNum = sfc.termNum;
                this.counts.put(name, sfc);
            }
            sfc.count += count;
            terms.fastSet(sfc.termNum);
            last = count;
        }
        if (numRequested < 0 || numRequested != 0 && numReceived < numRequested) {
            last = 0L;
        }
        this.missingMaxPossible += last;
        this.missingMax[shardNum] = last;
        this.counted[shardNum] = terms;
    }

    ShardFacetCount[] getSorted() {
        ShardFacetCount[] arr = this.counts.values().toArray(new ShardFacetCount[this.counts.size()]);
        Arrays.sort(arr, new Comparator<ShardFacetCount>(){

            @Override
            public int compare(ShardFacetCount o1, ShardFacetCount o2) {
                if (o2.count < o1.count) {
                    return -1;
                }
                if (o1.count < o2.count) {
                    return 1;
                }
                return o1.name.compareTo(o2.name);
            }
        });
        this.countSorted = arr;
        return arr;
    }

    String makeQuery(ShardFacetCount sfc) {
        return this.queryPrefix + sfc.name;
    }

    long maxPossible(ShardFacetCount sfc, int shardNum) {
        return this.missingMax[shardNum];
    }
}

