/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.util.NumberUtils;

class SortableLongFieldSource
extends FieldCacheSource {
    protected long defVal;
    private static int hcode = SortableLongFieldSource.class.hashCode();

    public SortableLongFieldSource(String field) {
        this(field, 0L);
    }

    public SortableLongFieldSource(String field, long defVal) {
        super(field);
        this.defVal = defVal;
    }

    public String description() {
        return "slong(" + this.field + ')';
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        FieldCache.StringIndex index = this.cache.getStringIndex(reader, this.field);
        final int[] order = index.order;
        final String[] lookup = index.lookup;
        final long def = this.defVal;
        return new DocValues(){

            public float floatVal(int doc) {
                return this.longVal(doc);
            }

            public int intVal(int doc) {
                return (int)this.longVal(doc);
            }

            public long longVal(int doc) {
                int ord = order[doc];
                return ord == 0 ? def : NumberUtils.SortableStr2long(lookup[ord], 0, 5);
            }

            public double doubleVal(int doc) {
                return this.longVal(doc);
            }

            public String strVal(int doc) {
                return Long.toString(this.longVal(doc));
            }

            public String toString(int doc) {
                return SortableLongFieldSource.this.description() + '=' + this.longVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof SortableLongFieldSource && super.equals(o) && this.defVal == ((SortableLongFieldSource)o).defVal;
    }

    public int hashCode() {
        return hcode + super.hashCode() + (int)this.defVal;
    }
}

