/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class SimplePostTool {
    public static final String DEFAULT_POST_URL = "http://localhost:8983/solr/update";
    public static final String POST_ENCODING = "UTF-8";
    public static final String VERSION_OF_THIS_TOOL = "1.2";
    private static final String SOLR_OK_RESPONSE_EXCERPT = "<int name=\"status\">0</int>";
    private static final String DEFAULT_COMMIT = "yes";
    private static final String DATA_MODE_FILES = "files";
    private static final String DATA_MODE_ARGS = "args";
    private static final String DATA_MODE_STDIN = "stdin";
    private static final String DEFAULT_DATA_MODE = "files";
    private static final Set<String> DATA_MODES = new HashSet<String>();
    protected URL solrUrl;

    public static void main(String[] args) {
        SimplePostTool.info("version 1.2");
        if (0 < args.length && "-help".equals(args[0])) {
            System.out.println("This is a simple command line tool for POSTing raw XML to a Solr\nport.  XML data can be read from files specified as commandline\nargs; as raw commandline arg strings; or via STDIN.\nExamples:\n  java -Ddata=files -jar post.jar *.xml\n  java -Ddata=args  -jar post.jar '<delete><id>42</id></delete>'\n  java -Ddata=stdin -jar post.jar < hd.xml\nOther options controlled by System Properties include the Solr\nURL to POST to, and whether a commit should be executed.  These\nare the defaults for all System Properties...\n  -Ddata=files\n  -Durl=http://localhost:8983/solr/update\n  -Dcommit=yes\n");
            return;
        }
        URL u = null;
        try {
            u = new URL(System.getProperty("url", DEFAULT_POST_URL));
        }
        catch (MalformedURLException e) {
            SimplePostTool.fatal("System Property 'url' is not a valid URL: " + u);
        }
        SimplePostTool t = new SimplePostTool(u);
        String mode = System.getProperty("data", "files");
        if (!DATA_MODES.contains(mode)) {
            SimplePostTool.fatal("System Property 'data' is not valid for this tool: " + mode);
        }
        try {
            if ("files".equals(mode)) {
                if (0 < args.length) {
                    SimplePostTool.info("POSTing files to " + u + "..");
                    int posted = t.postFiles(args, 0);
                }
            } else if (DATA_MODE_ARGS.equals(mode)) {
                if (0 < args.length) {
                    SimplePostTool.info("POSTing args to " + u + "..");
                    for (String a : args) {
                        StringWriter sw = new StringWriter();
                        t.postData(new StringReader(a), sw);
                        SimplePostTool.warnIfNotExpectedResponse(sw.toString(), SOLR_OK_RESPONSE_EXCERPT);
                    }
                }
            } else if (DATA_MODE_STDIN.equals(mode)) {
                SimplePostTool.info("POSTing stdin to " + u + "..");
                StringWriter sw = new StringWriter();
                t.postData(new InputStreamReader(System.in, POST_ENCODING), sw);
                SimplePostTool.warnIfNotExpectedResponse(sw.toString(), SOLR_OK_RESPONSE_EXCERPT);
            }
            if (DEFAULT_COMMIT.equals(System.getProperty("commit", DEFAULT_COMMIT))) {
                SimplePostTool.info("COMMITting Solr index changes..");
                StringWriter sw = new StringWriter();
                t.commit(sw);
                SimplePostTool.warnIfNotExpectedResponse(sw.toString(), SOLR_OK_RESPONSE_EXCERPT);
            }
        }
        catch (IOException ioe) {
            SimplePostTool.fatal("Unexpected IOException " + ioe);
        }
    }

    int postFiles(String[] args, int startIndexInArgs) throws IOException {
        int filesPosted = 0;
        for (int j = startIndexInArgs; j < args.length; ++j) {
            File srcFile = new File(args[j]);
            StringWriter sw = new StringWriter();
            if (srcFile.canRead()) {
                SimplePostTool.info("POSTing file " + srcFile.getName());
                this.postFile(srcFile, sw);
                ++filesPosted;
                SimplePostTool.warnIfNotExpectedResponse(sw.toString(), SOLR_OK_RESPONSE_EXCERPT);
                continue;
            }
            SimplePostTool.warn("Cannot read input file: " + srcFile);
        }
        return filesPosted;
    }

    static void warnIfNotExpectedResponse(String actual, String expected) {
        if (actual.indexOf(expected) < 0) {
            SimplePostTool.warn("Unexpected response from Solr: '" + actual + "' does not contain '" + expected + "'");
        }
    }

    static void warn(String msg) {
        System.err.println("SimplePostTool: WARNING: " + msg);
    }

    static void info(String msg) {
        System.out.println("SimplePostTool: " + msg);
    }

    static void fatal(String msg) {
        System.err.println("SimplePostTool: FATAL: " + msg);
        System.exit(1);
    }

    public SimplePostTool(URL solrUrl) {
        this.solrUrl = solrUrl;
        SimplePostTool.warn("Make sure your XML documents are encoded in UTF-8, other encodings are not currently supported");
    }

    public void commit(Writer output) throws IOException {
        this.postData(new StringReader("<commit/>"), output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFile(File file, Writer output) throws FileNotFoundException, UnsupportedEncodingException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), POST_ENCODING);
        try {
            this.postData(reader, output);
        }
        finally {
            try {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                throw new PostException("IOException while closing file", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postData(Reader data, Writer output) {
        HttpURLConnection urlc = null;
        try {
            urlc = (HttpURLConnection)this.solrUrl.openConnection();
            try {
                urlc.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new PostException("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
            }
            urlc.setDoOutput(true);
            urlc.setDoInput(true);
            urlc.setUseCaches(false);
            urlc.setAllowUserInteraction(false);
            urlc.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            OutputStream out = urlc.getOutputStream();
            try {
                OutputStreamWriter writer = new OutputStreamWriter(out, POST_ENCODING);
                SimplePostTool.pipe(data, writer);
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new PostException("IOException while posting data", e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            InputStream in = urlc.getInputStream();
            try {
                InputStreamReader reader = new InputStreamReader(in);
                SimplePostTool.pipe(reader, output);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new PostException("IOException while reading response", e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            try {
                SimplePostTool.fatal("Solr returned an error: " + urlc.getResponseMessage());
            }
            catch (IOException f) {
                // empty catch block
            }
            SimplePostTool.fatal("Connection error (is Solr running at " + this.solrUrl + " ?): " + e);
        }
        finally {
            if (urlc != null) {
                urlc.disconnect();
            }
        }
    }

    private static void pipe(Reader reader, Writer writer) throws IOException {
        char[] buf = new char[1024];
        int read = 0;
        while ((read = reader.read(buf)) >= 0) {
            writer.write(buf, 0, read);
        }
        writer.flush();
    }

    static {
        DATA_MODES.add("files");
        DATA_MODES.add(DATA_MODE_ARGS);
        DATA_MODES.add(DATA_MODE_STDIN);
    }

    private class PostException
    extends RuntimeException {
        PostException(String reason, Throwable cause) {
            super(reason + " (POST URL=" + SimplePostTool.this.solrUrl + ")", cause);
        }
    }
}

